% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a-misc.R
\name{time.to.tick}
\alias{time.to.tick}
\title{Convert date to tick number}
\usage{
time.to.tick(time, timestep = 30, origin = "2010-01-01", tz = "UTC", ...)
}
\arguments{
\item{time}{Character, or character vector, of the form 'YYYY-MM-DD'
(or 'YYYY-MM-DD HH:MM:SS'), or equivalent POSIX object. Date(s) to be converted
to ticks.}

\item{timestep}{Numeric (default 30). Length of each simulation time step in
minutes.}

\item{origin}{Character of the form 'YYYY-MM-DD' or equivalent POSIX object
(default "2010-01-01"). Start date of simulation.}

\item{tz}{Character. Valid time zone code (default UTC).}

\item{...}{Optional parameters.}
}
\value{
Numeric vector of tick numbers.
}
\description{
Convert a date to the number of ticks since simulation start while taking
into account that DEPONS assumes that there are 360 days in a simulation year.
}
\details{
Times are rounded down to the current 30-minute interval during conversion.
The function assumes that there are 30 days in each month, except in January,
February and March with 31, 28 and 31 days, respectively. Provided dates that
fall on days that are not accommodated (February 29, and the 31st day of the
months May, July, August, October, and December) are returned as NA.

The function may be used to, e.g., convert recorded piling dates to ticks for
use in wind farm scenarios (see \code{\link{make.windfarms}} for construction
of hypothetical scenarios from parametric inputs).
}
\examples{
\dontrun{
#Uses date column of AIS data.
#Times are in 30-minute intervals, and converting back yields the same times
data(aisdata)
ticks <- time.to.tick(aisdata$time, origin = "2015-12-20")
times_reconverted <- tick.to.time(ticks, origin = "2015-12-20")

#Uses dates at other intervals.
#Converting back yields times rounded down to the current 30-minute interval
times <- c("2016-12-20 00:10:00",
          "2016-12-20 02:45:30",
          "2016-12-20 05:01:05",
          "2016-12-22 01:30:00")
ticks <- time.to.tick(times, origin = "2015-12-20")
times_reconverted <- tick.to.time(ticks, origin = "2015-12-20")}

}
\seealso{
\code{\link{tick.to.time}} is the inverse of this function, converting
ticks to dates
}
