% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rep_overlay.R
\name{rep_overlay}
\alias{rep_overlay}
\title{Overlay ClimaRep classifications}
\usage{
rep_overlay(folder_path, output_dir = file.path(tempdir(), "ClimaRep_overlay"))
}
\arguments{
\item{folder_path}{\code{character}. The path to the directory containing the classification rasters (\code{.tif}) generated by \code{ClimaRep::mh_rep()} or \code{ClimaRep::mh_rep_ch()}. These rasters should primarily
contain the categories: \code{1} (Stable/Representative), \code{2} (Lost), and \code{3} (Novel).
Category \code{0} (Unsuitable) will be ignored for the RGB output.}

\item{output_dir}{\code{character}. Path to the directory where the output file will be saved.}
}
\value{
Writes the following outputs within the directory specified by \code{output_dir}:
When \code{ClimaRep::mh_rep()} results are used, the output layers consistently represent counts for \strong{Representative} categories across all input rasters.
When \code{ClimaRep::mh_rep_ch()} results are used, the output layers consistently represent counts for \strong{Lost} (Red), \strong{Stable} (Green), and \strong{Novel} (Blue) categories across all input rasters. Designed for direct RGB plotting.
\itemize{
\item A multi-layered \code{SpatRaster} (\code{ClimaRep_overlay.tif}) for RGB visualization.
\item Individual \code{.tif} files for each band (Lost, Stable, Novel) in \verb{Individual_Bands/} subdirectory.
\item \verb{Additional note}: The \code{ClimaRep::mh_rep()} function analyzes a single period. When its output is used, representative cells are all categorized as Stable (value 1), while other categories (Lost and Novel) have a value of zero.
}
}
\description{
Combines multiple single-layer rasters (\code{tif}), outputs from \code{ClimaRep::mh_rep()} or \code{ClimaRep::mh_rep_ch()} for different input polygons, into a multi-layered \code{SpatRaster}.

This function handles inputs from both \code{ClimaRep::mh_rep()} (which primarily contains \strong{Representative} cells) and \code{ClimaRep::mh_rep_ch()} (which includes \strong{Stable}, \strong{Lost}, and \strong{Novel} cells). The output layers consistently represent counts of each input.
}
\details{
This function streamlines the aggregation of ClimaRep classifications. It is designed to work with outputs from both \code{ClimaRep::mh_rep()} and \code{ClimaRep::mh_rep_ch}.

For each of the three key categories (Lost, Stable/Representative, Novel), the function:
\enumerate{
\item Identifies and reads all \code{.tif} files within the \code{folder_path}.
\item For each input raster, it creates a binary layer: \code{1} if the cell's value matches the target category (e.g., \code{2} for 'Lost'), and \code{0} otherwise.
\item Sums these binary layers to generate a cumulative count for that specific category at each grid cell.
}

The three resulting count layers (Lost, Stable, Novel) are then consistently stacked in the following order:
\itemize{
\item First layer (Red): Cumulative count of Lost.
\item Second layer (Green): Cumulative count of Stable.
\item Third layer (Blue): Cumulative count of Novel.
}
This fixed order ensures that the output \code{SpatRaster} is immediately ready for direct RGB visualization using \code{terra::plotRGB()}, where the color mixtures will intuitively reflect
the spatial agreement of these change types.

The output \code{SpatRaster} contains raw counts. While \code{terra::plotRGB()} often handles stretching for visualization, users might normalize these counts manually (e.g., to 0-number of \code{polygons}) for finer visual contrast.

A new subfolder named \verb{overlay/} will be created within the \code{folder_path}. The resulting three-layered RGB will be saved as \code{ClimaRep_overlay.tif} inside this new \verb{overlay/} subfolder.
}
\examples{
ClimaRep_overlay <- ClimaRep::rep_overlay(folder_path = system.file("extdata",
                                                                    package = "ClimaRep"),
                                         output_dir = file.path(tempdir(), "rep_overlay_output"))
terra::plotRGB(ClimaRep_overlay)
terra::plot(ClimaRep_overlay)
}
