% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_coef_significant.R
\name{check_coef_significant}
\alias{check_coef_significant}
\title{Check Significance of Excluded Variables}
\usage{
check_coef_significant(data, yval, xpre, xcheck, strata = NULL)
}
\arguments{
\item{data}{A data frame containing the outcome, predictors, and optionally a stratification variable.}

\item{yval}{A string naming the binary outcome variable.}

\item{xpre}{A character vector of variables included in the preliminary model.}

\item{xcheck}{A character vector of variables to be tested for significance when added individually to the preliminary model.}

\item{strata}{(Optional) A string naming the stratification variable. If provided, conditional logistic regression is used via \code{clogit()}.}
}
\value{
A matrix containing the coefficient estimates, standard errors, z-values,
and p-values for each variable in \code{xcheck} when added to the preliminary model.
}
\description{
Obtain summary statistics, including Wald test z-values and p-values, for coefficients
of variables added one at a time to an existing logistic regression model.
Supports both standard and conditional logistic regression.
}
\details{
For each variable in \code{xcheck}, this function fits a model that includes the variable
alongside \code{xpre}. It extracts and returns the coefficient summary for each added variable
to assess statistical significance. When \code{strata} is provided, a conditional logistic regression
model is used instead of standard logistic regression.
}
\examples{
# Example from Hosmer et al., 2013
# Applied Logistic Regression (3rd ed.), Chapter 4

# Variables selected for the full model
preliminar <- c('age', 'height', 'priorfrac', 'momfrac', 'armassist', 'raterisk')

# Variables to test
excluded <- c('weight', 'bmi', 'premeno', 'smoke')

# Assess whether any excluded variables become significant when added to the preliminary model
check_coef_significant(data = glow500, yval = 'fracture', xpre = preliminar, xcheck = excluded)

}
