% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ca_to_ps_matrix.R
\name{ca_to_ps_matrix}
\alias{ca_to_ps_matrix}
\title{CADF to purchase string 
Extracts purchase strings from the CADF and formats as a R matrix.}
\usage{
ca_to_ps_matrix(ca.data, maxT)
}
\arguments{
\item{ca.data}{Data in the CADF format generated by the CADF _to_CADF functions and Customer class.}

\item{maxT}{Number of columns in the matrix}
}
\value{
Matrix with dimensions C x maxT  (number of customers by maxT)
library(CADF)
data("transactions")
customer <- subset(transactions, transactions$ID == 40)
today.study.cutoff <- max(customer$PURCHASE_DATE)
customer.40.CADF <- list(Customer$new(customer, today.study.cutoff))
psmatrix <- customer.40.CADF$purchase_string_as_matrix
psmatrix2 <- ca_to_ps_matrix(customer.40.CADF, 15)
}
\description{
CADF to purchase string 
Extracts purchase strings from the CADF and formats as a R matrix.
}
\details{
Output is a matrix.  Rows are number of customers; columns = maxT
}
