% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.variability.R
\name{is.variability}
\alias{is.variability}
\title{Reports whether x is a 'variability' object}
\usage{
is.variability(x)
}
\arguments{
\item{x}{an object to test.}
}
\value{
Returns TRUE if its argument is of class \code{variability} and FALSE otherwise.
}
\description{
Reports whether x is a 'variability' object
}
\examples{
Pbox.BC <- subset(Pbox, Team=="Oklahoma City Thunder" & MIN >= 500,
                    select=c("P2p","P3p","FTp","P2A","P3A","FTA"))
out <- variability(data=Pbox.BC, data.var=c("P2p","P3p","FTp"),
                   size.var=c("P2A","P3A","FTA"), weight=TRUE)
is.variability(out)
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\seealso{
\code{\link{variability}}
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
