% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{area_lookup}
\alias{area_lookup}
\title{Area Lookup Tables (QCEW)}
\format{
A data frame with 4649 rows and 5 columns:
\itemize{
  \item{area_fips - Character.  The area FIPS code.  When all numeric characters, it represents either a state or a county definition.}
  \item{area_title - Character. The descripion of the area code provided by the Bureau of Labor Statistics.}
  \item{area_type - Character. A desription ot the type of area defined.  Values are National, State, County, County Unknown or Undefined, National Subgroup, Combined Statistical Area, Metropolitan Statistical Area, or Micropolitan Statistical Area.}
  \item{stfips - Character. For state or counties, the two-digit FIPS code of the associated state.  For national areas, or those areas which may span multiple states the value is "00".}
  \item{specified_region - Either the two-character US Postal abbreviation for a state or group of states, or "No region" for other areas.}
}
}
\source{
\url{https://www.bls.gov/cew/classifications/areas/qcew-area-titles.htm}
}
\usage{
data(area_lookup)
}
\description{
A data frame containing area codes, titles, and additional geographic information about valid areas for the Quarterly Census of Employment and Wages (QCEW).

This table is primarily used internally by `BLSloadR` functions to add human-readable area titles or define valid area lookups.
}
\details{
Area codes are five characters long. When all numeric characters, this is a state-county FIPS, with statewide data using a "000" as the county FIPS.  Other aggregations include various alphabetic characters to aid in the classification of different regions.
}
\examples{
# Load the lookup table
data(area_lookup)

# Find the area codes for all Statewide areas
state_codes <- area_lookup[area_lookup$area_type == "State", ]

# Get all Metropolitan Statistical Area codes including Arkansas.
ar_codes <- area_lookup |> 
dplyr::filter(grepl("AR", specified_region) &
 area_type == "Metropolitan Statistical Area")
}
\keyword{datasets}
