% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateInputs.R
\name{createInputs.default}
\alias{createInputs.default}
\alias{createInputs}
\alias{createInputs.rjags}
\alias{createInputs.bugs}
\alias{createInputs.stanfit}
\alias{createInputs.data.frame}
\alias{createInputs.numeric}
\title{Create Inputs for EVPI Calculation}
\usage{
\method{createInputs}{default}(inputs, print_is_linear_comb = TRUE)

createInputs(inputs, print_is_linear_comb = TRUE)

\method{createInputs}{rjags}(inputs, print_is_linear_comb = TRUE)

\method{createInputs}{bugs}(inputs, print_is_linear_comb = TRUE)

\method{createInputs}{stanfit}(inputs, print_is_linear_comb = TRUE)

\method{createInputs}{data.frame}(inputs, print_is_linear_comb = TRUE)

\method{createInputs}{numeric}(inputs, print_is_linear_comb = TRUE)
}
\arguments{
\item{inputs}{An object containing suitable simulations for the model
parameters. It can be a \code{rjags} or \code{bugs} object (obtained directly by
running \code{R2jags}, \code{rjags}, \code{R2OpenBUGS} or \code{R2WinBUGS}). For those objects,
which are in the class \code{rjags} or \code{bugs}, the user can simply pass them to
\code{createInputs()}, which will now how to process them. If the user has
run their model using \code{rstan}, then they should pre-process the output using
the \code{rstan::extract()} function; so if \code{rstan} is used to run a Bayesian
model and save the results to, say, the object \code{fit}, then the user should
first create another object \code{tmp=rstan::extract(fit) |> as.data.frame()}
and then pass this onto \code{createInputs()}. Finally, this function handles
inputs from data-frames of vectors directly.}

\item{print_is_linear_comb}{Logical indicator. If set to \code{TRUE} (default)
then prints the output of the procedure trying to assess whether there are
some parameters that are a linear combination of others (in which case
they are removed).}
}
\value{
\item{mat}{Data.frame containing all the simulations
for all the monitored parameters}
\item{parameters}{Character vectors of the names
of all the monitored parameters}
}
\description{
Creates an object containing the matrix with the parameters simulated using
the MCMC procedure (using JAGS, BUGS or Stan) and a vector of parameters
(strings) that can be used to perform the expected value of partial
information analysis. In the process, \code{createInputs} also checks for
linear dependency among columns of the PSA samples or columns having
constant values and removes them to only leave the fundamental parameters
(to run VoI analysis). This also deals with simulations stored in a
\code{.csv} or \code{.txt} file (e.g. as obtained using bootstrapping from a
non-Bayesian model).
}
\seealso{
\code{\link[=bcea]{bcea()}},
\code{\link[=evppi]{evppi()}}
}
\author{
Gianluca Baio, Anna Heath and Mark Strong
}
