% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_filter_data.R
\name{do_filter_data}
\alias{do_filter_data}
\title{Filter shooting data}
\usage{
do_filter_data(data_shots_zones, season_str, team, period, minute_vect, place, player)
}
\arguments{
\item{data_shots_zones}{Shooting data with the court zones.}

\item{season_str}{String with the season.}

\item{team}{String with the team's full name. Nothing to filter if "".}

\item{period}{Number with the periods (1, 2, 3 and 4 for the common 
four quarters, 5 for the first overtime and 6 for the second overtime).
Nothing to filter if "".}

\item{minute_vect}{Vector with the minutes to filter by. 
Nothing to filter if "".}

\item{place}{String. If "Home" or "Casa", the local games are filtered.
Nothing to filter if "".}

\item{player}{String with the player's name. Nothing to filter if "".}
}
\value{
A data frame with the filters applied.
}
\description{
Filter the shooting data with the team or player of interest, and also by periods, minutes and game place.
If neither team nor player is given, the data from the whole league is used.
}
\examples{
\dontrun{
df0 <- do_divide_court_zones(acb_shooting_data_2425)

# Data for the whole league:
df1 <- do_filter_data(df0, "2024-2025", "", "", "", "", "")

# Data for a team:
df1 <- do_filter_data(df0, "2024-2025", "UCAM Murcia", "", "", "", "")

# Data for a player:
df1 <- do_filter_data(df0, "2024-2025", "", "", "", "", "D. Ennis")

# Other filters:
# By minutes:
df1 <- do_filter_data(df0, "2024-2025", "", "", c(8,10), "", "D. Ennis")
}

}
\seealso{
\code{\link{do_divide_court_zones}}
}
\author{
Guillermo Vinue
}
