% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/occurrence.R
\docType{methods}
\name{occurrence}
\alias{occurrence}
\alias{occurrence-method}
\alias{occurrence,EventsMCMC-method}
\title{Occurrence Plot}
\usage{
occurrence(object, ...)

\S4method{occurrence}{EventsMCMC}(object, level = 0.95)
}
\arguments{
\item{object}{An \code{\linkS4class{EventsMCMC}} object.}

\item{...}{Currently not used.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}
}
\value{
An \code{\linkS4class{OccurrenceEvents}} object.

An \code{\linkS4class{OccurrenceEvents}} object.
}
\description{
A statistical graphic designed for the archaeological study of when
events of a specified kind occurred.
}
\details{
If we have \eqn{k} events, then we can estimate the calendar date \eqn{t}
corresponding to the smallest date such that the number of events observed
before \eqn{t} is equal to \eqn{k}.

The \code{occurrence()} estimates these occurrences and gives the credible
interval or the highest posterior density (HPD) region for a given \code{level}
of confidence.
}
\examples{
## Coerce to MCMC
eve <- as_events(mcmc_events, calendar = CE(), iteration = 1)
eve <- eve[1:10000, ]

## Occurrence plot
occ <- occurrence(eve)
plot(occ, panel.first = graphics::grid())
}
\seealso{
Other event tools: 
\code{\link{activity}()},
\code{\link{elapse}()},
\code{\link{tempo}()}
}
\author{
A. Philippe, M.-A. Vibet, T. S. Dye, N. Frerebeau
}
\concept{event tools}
