% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ss_tscore}
\alias{ss_tscore}
\title{Compute T-score}
\usage{
ss_tscore(
  data,
  data_norm = NULL,
  vars,
  name = "tscore",
  max_na = NULL,
  exclude = NULL,
  col_age = "age",
  col_sex = "sex",
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{data_norm}{tbl. Data frame containing the T-score table. See details.}

\item{vars}{character vector. The names of the columns to be summarized.}

\item{name}{character. The column name of the T-score.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed (Default: NULL; no restriction on missing values).}

\item{exclude}{character (vector). The value(s) to be excluded (Default:
NULL; all values are used).}

\item{col_age}{character. The name of the age column.}

\item{col_sex}{character The name of sex column.}

\item{combine}{logical. Whether to combine the summary score column with the
input data frame (Default: TRUE).}
}
\value{
tbl. The input data frame with the T-score appended as a new column
if \code{combine} is TRUE, otherwise only the T-score column.
}
\description{
This function computes the T-score based on the given columns,
and the provided T-score table.
}
\details{
\subsection{T-score table}{

The \code{data_norm} should be a data frame containing the T-score table. The
default value \code{NULL} is only used for internal usage (see below). For normal
usage, the \code{data_norm} should be provided.

The table should have the following columns:
\itemize{
\item \code{sex}: character or factor both ok. The biological sex of the participant.
The values should be either "1" (male) or "2" (female).
\item \code{age_min}: numeric. The minimum age of the participant.
\item \code{age_max}: numeric. The maximum age of the participant.
\item \code{scale_r}: numeric. The raw score of the scale.
\item \code{scale_t}: numeric. The T-score of the scale.
}

For example

A tibble: n x 5\tabular{lllll}{
   sex \tab age_min \tab age_max \tab scale_r \tab scale_t \cr
   \verb{<chr>} \tab \verb{<dbl>} \tab \verb{<dbl>} \tab \verb{<dbl>} \tab \verb{<dbl>} \cr
   1 \tab 18 \tab 35 \tab 50 \tab 1 \cr
   1 \tab 18 \tab 35 \tab 50.5 \tab 2 \cr
   1 \tab 18 \tab 35 \tab 51 \tab 3 \cr
   1 \tab 18 \tab 35 \tab 51.5 \tab 4 \cr
   ... \tab  \tab  \tab  \tab  \cr
}

}

\subsection{out-range values}{
\itemize{
\item If the age of the participant is out of the range of the T-score table,
the function will return \code{NA}.
\item If the raw score is out of the range of the T-score table, the function
will return \code{NA}.
\item If any of the  \code{sex} column is not "1" or "2",
the function will return \code{NA}.
\item If any of the required columns has \code{NA}, that row will return \code{NA}.
}
}

\subsection{Internal usage}{

When used in DSM internally, the \code{data_norm} can be omitted. Instead, the
function will try to find the T-score table from the \code{list_tscore} option,
and tries to find the tscore list based on object name provided in the
\code{list_tscore} option. Once the object is found, the function will automatically
extract the T-score table based on the function name.
\itemize{
\item The \code{list_tscore} object should present in the global environment.
\item See \code{\link[=get_tscore_tbl]{get_tscore_tbl()}} for more details on how to construct
the \code{list_tscore}.
}

For example

\if{html}{\out{<div class="sourceCode r">}}\preformatted{my_tscore <<- readRDS("aseba_tscore.rds")
options(list_tscore = "my_tscore")
compute_mh_x_yyyy_zz_tscore(data)
}\if{html}{\out{</div>}}
}
}
\examples{
data_norm <- tibble::tibble(
  sex = c("1", "1", "1", "1", "1"),
  age_min = 18,
  age_max = 35,
  scale_r = 0:4,
  scale_t = 20:24
)
data <- tibble::tibble(
  var1 = c(0, 1, NA, 1, 2),
  var2 = c(1, 2, 1, 2, 5),
  age = c(18, 20, 25, 99, 35),
  sex = c("1", "1", "1", "1", "1")
)
ss_tscore(
  data = data,
  data_norm = data_norm,
  max_na = 0,
  vars = c("var1", "var2")
)
}
