% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ss_count}
\alias{ss_count}
\title{Compute the number or count of matching conditions}
\usage{
ss_count(
  data,
  name,
  vars,
  vars_temp = NULL,
  exclude = NULL,
  combine = FALSE,
  allow_missingness = TRUE,
  cond
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. The name of the summary score.}

\item{vars}{character vector. The name(s) of the column(s) to be summarized.}

\item{vars_temp}{character vector. The name(s) of temporary column(s) used
to compute the summary score. Note, these columns are not checked for
missingness. See \code{allow_missingness}.}

\item{exclude}{character (vector). The value(s) to be excluded (Default:
NULL; all values are used).}

\item{combine}{logical. Whether to combine the summary score column with the
input data frame (Default: FALSE).}

\item{allow_missingness}{logical. Default set to TRUE. If TRUE, summary score
is set to \code{NA} only when ALL the in-going fields have missingness.
If FALSE, summary score is set to \code{NA} when ANY of the in-going fields
have missingness. NOTE: \code{exclude} operation is performed prior to checking
for missingness.}

\item{cond}{character vector. Each specified condition, involving the values
of specific input fields, gets tested for \code{1} (\code{TRUE}) or \code{0} (\code{FALSE}).
If a condition is specified as \code{"field_name"}, the numeric value
in the field is counted and could be greater than 1. Whereas other
conditions when met can get a value of \code{1} or \code{0}. The summary score
is a sum over all the values obtained from testing each condition
specified in \code{cond}.}
}
\value{
tbl. The input data frame with the summary score appended as a new
column.
}
\description{
Computes the number of conditions (provided as a character vector\code{cond}),
involving the input variables \code{vars}, that were found to be \code{TRUE}.
Options available to exclude certain values from the input variables
(provided as a character vector \code{exclude}).
}
\examples{
dat <- tibble::tibble(
  id   = c("1", "2", "3", "4", "5", "6", "7", "8"),
  a_1  = c(1, 1, NA, 1, 1, 1, 1, 1),
  a_2  = c(1, NA, NA, 1, 1, NA, 1, 1),
  b_1  = c(1, 1, NA, NA, 1, 1, 1, 1),
  b_2  = c(1, 1, NA, 1, 1, NA, 1, 1),
  c    = c(NA, 1, NA, 1, 777, 0, 1, 0)
)

# define conditions to assess
conditions <- c(
  "a_1 == 1 & a_2 == 1",
  "b_1 == 1 & b_2 == 1",
  "c"
)

# count number of matched conditions
ss_count(
  data    = dat,
  name    = "ss",
  vars    = c("a_1", "a_2", "b_1", "b_2", "c"),
  cond    = conditions,
  combine = TRUE
)

ss_count(
  data    = dat,
  name    = "ss",
  vars    = c("a_1", "a_2", "b_1", "b_2", "c"),
  cond    = conditions,
  exclude = c("777"),
  combine = TRUE
)

conditions <- paste(
  c(
    "a_1 == 1 & a_2 == 1",
    "b_1 == 1 & b_2 == 1",
    "c >= 1"
  ),
  collapse = "&"
)

ss_count(
  data    = dat,
  name    = "ss",
  vars    = c("a_1", "a_2", "b_1", "b_2", "c"),
  cond    = conditions,
  exclude = c("777"),
  combine = TRUE
)

ss_count(
  data = dat,
  name = "ss",
  vars = c("a_1", "a_2", "b_1", "b_2", "c"),
  cond = conditions,
  exclude = c("777"),
  allow_missingness = FALSE,
  combine = TRUE
)

}
