/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.metaAnalysis;

import dr.inference.distribution.EmpiricalDistributionData;
import dr.inference.distribution.EmpiricalDistributionLikelihood;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.ohdsi.metaAnalysis.DataModel;

public class ParametricDataModel
extends DataModel.Base
implements DataModel {
    public ParametricDataModel(String fileName) {
        this();
        File file = new File(fileName);
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            Scanner inputStream = new Scanner(file);
            while (inputStream.hasNext()) {
                String line = inputStream.next();
                line = line.replaceAll("\"", "");
                String[] values = line.split(",");
                lines.add(Arrays.asList(values));
            }
            inputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        int muIdx = ((List)lines.get(0)).indexOf("mu");
        int sigmaIdx = ((List)lines.get(0)).indexOf("sigma");
        int gammaIdx = ((List)lines.get(0)).indexOf("gamma");
        int i = 1;
        while (i < lines.size()) {
            double[] parameters = new double[]{Double.parseDouble((String)((List)lines.get(i)).get(muIdx)), Double.parseDouble((String)((List)lines.get(i)).get(sigmaIdx)), Double.parseDouble((String)((List)lines.get(i)).get(gammaIdx))};
            this.addLikelihoodParameters(parameters, null);
            ++i;
        }
        this.finish();
    }

    public ParametricDataModel() {
    }

    @Override
    EmpiricalDistributionLikelihood makeFunctionalForm(List<EmpiricalDistributionData> dataList) {
        return new EmpiricalDistributionLikelihood(dataList, false){
            private static final long serialVersionUID = 5902404628932924630L;

            private final double sqr(double x) {
                return x * x;
            }

            protected double logPDF(double x, EmpiricalDistributionData data) {
                double mu = data.values[0];
                double sigma = data.values[1];
                double gamma = data.values[2];
                return Math.exp(gamma * (x - mu)) * (-this.sqr(x - mu) / (2.0 * this.sqr(sigma)));
            }

            protected double gradientLogPdf(double x, EmpiricalDistributionData data) {
                double mu = data.values[0];
                double sigma = data.values[1];
                double gamma = data.values[2];
                return -(Math.exp(gamma * (x - mu)) * (gamma * (x - mu) + 2.0) * (x - mu)) / (2.0 * this.sqr(sigma));
            }
        };
    }
}

