/*
 * Decompiled with CFR 0.152.
 */
package org.act.rscat.cat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CatItemsToAdminister {
    private static final String NULL_LIST_ITEMS_ALREADY_ADMINISTERED = "listItemsAlreadyAdministered cannot be null";
    private static final String NULL_LIST_ITEMS_TO_ADMINISTERED = "listItemsToAdminister cannot be null";
    private List<String> listItemsToAdminister = new ArrayList<String>();
    private List<String> listItemsAlreadyAdministered = new ArrayList<String>();
    private int numItemsToAdminister = 1;

    public CatItemsToAdminister(List<String> listItemsToAdminister, List<String> listItemsAlreadyAdministered, int numItemsToAdminister) {
        if (listItemsToAdminister == null) {
            throw new NullPointerException(NULL_LIST_ITEMS_TO_ADMINISTERED);
        }
        if (listItemsAlreadyAdministered == null) {
            throw new NullPointerException(NULL_LIST_ITEMS_ALREADY_ADMINISTERED);
        }
        this.listItemsToAdminister = listItemsToAdminister;
        this.listItemsAlreadyAdministered = listItemsAlreadyAdministered;
        this.numItemsToAdminister = numItemsToAdminister;
    }

    public CatItemsToAdminister(String[] listItemsToAdminister, String[] listItemsAlreadyAdministered, int numItemsToAdminister) {
        if (listItemsToAdminister == null) {
            throw new NullPointerException(NULL_LIST_ITEMS_TO_ADMINISTERED);
        }
        if (listItemsAlreadyAdministered == null) {
            throw new NullPointerException(NULL_LIST_ITEMS_ALREADY_ADMINISTERED);
        }
        this.listItemsToAdminister = Arrays.asList(listItemsToAdminister);
        this.listItemsAlreadyAdministered = Arrays.asList(listItemsAlreadyAdministered);
        this.numItemsToAdminister = numItemsToAdminister;
    }

    public List<String> getListItemsToAdminister() {
        return this.listItemsToAdminister;
    }

    public List<String> getListItemsAlreadyAdministered() {
        return this.listItemsAlreadyAdministered;
    }

    public int getNumItemsToAdminister() {
        return this.numItemsToAdminister;
    }

    public List<String> getItemsToAdmin() {
        return this.listItemsToAdminister.subList(0, this.numItemsToAdminister);
    }
}

