/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.util.prometheus.parser;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Counter;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Gauge;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Histogram;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.MetricFamily;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.MetricType;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Summary;
import org.apache.skywalking.oap.server.library.util.prometheus.parser.sample.TextSample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context {
    private static final Logger LOG = LoggerFactory.getLogger(Context.class);
    public MetricFamily metricFamily;
    public String name = "";
    public String help = "";
    public MetricType type = null;
    public List<String> allowedNames = new ArrayList<String>();
    public List<TextSample> samples = new ArrayList<TextSample>();
    private final long now;

    void addAllowedNames(String type) {
        this.type = MetricType.valueOf(type.toUpperCase());
        this.allowedNames.clear();
        switch (this.type) {
            case COUNTER: 
            case GAUGE: {
                this.allowedNames.add(this.name);
                break;
            }
            case SUMMARY: {
                this.allowedNames.add(this.name + "_count");
                this.allowedNames.add(this.name + "_sum");
                this.allowedNames.add(this.name);
                break;
            }
            case HISTOGRAM: {
                this.allowedNames.add(this.name + "_count");
                this.allowedNames.add(this.name + "_sum");
                this.allowedNames.add(this.name + "_bucket");
            }
        }
    }

    void clear() {
        this.name = "";
        this.help = "";
        this.type = null;
        this.allowedNames.clear();
        this.samples.clear();
    }

    void end() {
        if (this.metricFamily != null) {
            return;
        }
        MetricFamily.Builder metricFamilyBuilder = new MetricFamily.Builder();
        metricFamilyBuilder.setName(this.name);
        metricFamilyBuilder.setHelp(this.help);
        metricFamilyBuilder.setType(this.type);
        if (this.samples.size() < 1) {
            return;
        }
        switch (this.type) {
            case GAUGE: {
                this.samples.forEach(textSample -> metricFamilyBuilder.addMetric(Gauge.builder().name(this.name).value(Context.convertStringToDouble(textSample.getValue())).labels(textSample.getLabels()).timestamp(this.now).build()));
                break;
            }
            case COUNTER: {
                this.samples.forEach(textSample -> metricFamilyBuilder.addMetric(Counter.builder().name(this.name).value(Context.convertStringToDouble(textSample.getValue())).labels(textSample.getLabels()).timestamp(this.now).build()));
                break;
            }
            case HISTOGRAM: {
                this.samples.stream().map(sample -> {
                    HashMap labels = Maps.newHashMap(sample.getLabels());
                    labels.remove("le");
                    return Pair.of((Object)labels, (Object)sample);
                }).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList()))).forEach((labels, samples) -> {
                    Histogram.HistogramBuilder hBuilder = Histogram.builder();
                    hBuilder.name(this.name).timestamp(this.now);
                    hBuilder.labels((Map<? extends String, ? extends String>)labels);
                    samples.forEach(textSample -> {
                        if (textSample.getName().endsWith("_count")) {
                            hBuilder.sampleCount((long)Context.convertStringToDouble(textSample.getValue()));
                        } else if (textSample.getName().endsWith("_sum")) {
                            hBuilder.sampleSum(Context.convertStringToDouble(textSample.getValue()));
                        } else if (textSample.getLabels().containsKey("le")) {
                            hBuilder.bucket(Context.convertStringToDouble(textSample.getLabels().remove("le")), (long)Context.convertStringToDouble(textSample.getValue()));
                        }
                    });
                    metricFamilyBuilder.addMetric(hBuilder.build());
                });
                break;
            }
            case SUMMARY: {
                this.samples.stream().map(sample -> {
                    HashMap labels = Maps.newHashMap(sample.getLabels());
                    labels.remove("quantile");
                    return Pair.of((Object)labels, (Object)sample);
                }).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList()))).forEach((labels, samples) -> {
                    Summary.SummaryBuilder sBuilder = Summary.builder();
                    sBuilder.name(this.name).timestamp(this.now);
                    sBuilder.labels((Map<? extends String, ? extends String>)labels);
                    samples.forEach(textSample -> {
                        if (textSample.getName().endsWith("_count")) {
                            sBuilder.sampleCount((long)Context.convertStringToDouble(textSample.getValue()));
                        } else if (textSample.getName().endsWith("_sum")) {
                            sBuilder.sampleSum(Context.convertStringToDouble(textSample.getValue()));
                        } else if (textSample.getLabels().containsKey("quantile")) {
                            sBuilder.quantile(Context.convertStringToDouble(textSample.getLabels().remove("quantile")), Context.convertStringToDouble(textSample.getValue()));
                        }
                    });
                    metricFamilyBuilder.addMetric(sBuilder.build());
                });
            }
        }
        this.metricFamily = metricFamilyBuilder.build();
    }

    private static double convertStringToDouble(String valueString) {
        double doubleValue = valueString.equalsIgnoreCase("NaN") ? Double.NaN : (valueString.equalsIgnoreCase("+Inf") ? Double.POSITIVE_INFINITY : (valueString.equalsIgnoreCase("-Inf") ? Double.NEGATIVE_INFINITY : Double.parseDouble(valueString)));
        return doubleValue;
    }

    @Generated
    public Context(long now) {
        this.now = now;
    }
}

