/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.asyncprofiler.provider.handler.stream;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.apm.network.language.asyncprofiler.v10.AsyncProfilerCollectionResponse;
import org.apache.skywalking.apm.network.language.asyncprofiler.v10.AsyncProfilerData;
import org.apache.skywalking.apm.network.language.asyncprofiler.v10.AsyncProfilingStatus;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerTask;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerTaskLogOperationType;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.JFRProfilingData;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.core.storage.profiling.asyncprofiler.IAsyncProfilerTaskQueryDAO;
import org.apache.skywalking.oap.server.library.jfr.parser.JFRParser;
import org.apache.skywalking.oap.server.library.jfr.type.Arguments;
import org.apache.skywalking.oap.server.library.jfr.type.FrameTree;
import org.apache.skywalking.oap.server.library.jfr.type.JFREventType;
import org.apache.skywalking.oap.server.receiver.asyncprofiler.provider.handler.AsyncProfilerServiceHandler;
import org.apache.skywalking.oap.server.receiver.asyncprofiler.provider.handler.stream.AsyncProfilerCollectionMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncProfilerFileCollectionObserver
implements StreamObserver<AsyncProfilerData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncProfilerFileCollectionObserver.class);
    private final IAsyncProfilerTaskQueryDAO taskDAO;
    private final SourceReceiver sourceReceiver;
    private final int jfrMaxSize;
    private final StreamObserver<AsyncProfilerCollectionResponse> responseObserver;
    private AsyncProfilerCollectionMetaData taskMetaData;
    private Path tempFile;
    private FileOutputStream fileOutputStream;

    public AsyncProfilerFileCollectionObserver(IAsyncProfilerTaskQueryDAO taskDAO, StreamObserver<AsyncProfilerCollectionResponse> responseObserver, SourceReceiver sourceReceiver, int jfrMaxSize) {
        this.sourceReceiver = sourceReceiver;
        this.taskDAO = taskDAO;
        this.responseObserver = responseObserver;
        this.jfrMaxSize = jfrMaxSize;
    }

    public void onNext(AsyncProfilerData asyncProfilerData) {
        if (Objects.isNull(this.taskMetaData) && asyncProfilerData.hasMetaData()) {
            this.taskMetaData = AsyncProfilerServiceHandler.parseMetaData(asyncProfilerData.getMetaData(), this.taskDAO);
            AsyncProfilerTask task = this.taskMetaData.getTask();
            if (AsyncProfilingStatus.PROFILING_SUCCESS.equals((Object)this.taskMetaData.getType())) {
                if (this.jfrMaxSize >= this.taskMetaData.getContentSize()) {
                    this.tempFile = Files.createTempFile(task.getId() + this.taskMetaData.getInstanceId() + System.currentTimeMillis(), ".jfr", new FileAttribute[0]);
                    this.fileOutputStream = new FileOutputStream(this.tempFile.toFile());
                    this.responseObserver.onNext((Object)AsyncProfilerCollectionResponse.newBuilder().build());
                } else {
                    this.responseObserver.onNext((Object)AsyncProfilerCollectionResponse.newBuilder().setType(AsyncProfilingStatus.TERMINATED_BY_OVERSIZE).build());
                    AsyncProfilerServiceHandler.recordAsyncProfilerTaskLog(task, this.taskMetaData.getInstanceId(), AsyncProfilerTaskLogOperationType.JFR_UPLOAD_FILE_TOO_LARGE_ERROR);
                }
            } else {
                AsyncProfilerServiceHandler.recordAsyncProfilerTaskLog(task, this.taskMetaData.getInstanceId(), AsyncProfilerTaskLogOperationType.EXECUTION_TASK_ERROR);
            }
        } else if (asyncProfilerData.hasContent()) {
            this.fileOutputStream.write(asyncProfilerData.getContent().toByteArray());
        }
    }

    public void onError(Throwable throwable) {
        Status status = Status.fromThrowable((Throwable)throwable);
        if (Status.CANCELLED.getCode() == status.getCode()) {
            if (log.isDebugEnabled()) {
                log.debug(throwable.getMessage(), throwable);
            }
            return;
        }
        log.error("Error in receiving async profiler profiling data", throwable);
    }

    public void onCompleted() {
        this.responseObserver.onCompleted();
        if (Objects.nonNull(this.tempFile)) {
            this.fileOutputStream.close();
            this.parseAndStorageData(this.taskMetaData, this.tempFile.toAbsolutePath().toString());
            if (!this.tempFile.toFile().delete()) {
                log.warn("Failed to delete temp JFR file {}", (Object)this.tempFile.toAbsolutePath());
            }
        }
    }

    private void parseAndStorageData(AsyncProfilerCollectionMetaData taskMetaData, String fileName) throws IOException {
        AsyncProfilerTask task = taskMetaData.getTask();
        if (task == null) {
            log.error("AsyncProfiler instanceId:{} has not been assigned a task but still uploaded data", (Object)taskMetaData.getInstanceId());
            return;
        }
        AsyncProfilerServiceHandler.recordAsyncProfilerTaskLog(task, taskMetaData.getInstanceId(), AsyncProfilerTaskLogOperationType.EXECUTION_FINISHED);
        this.parseJFRAndStorage(taskMetaData, fileName);
    }

    public void parseJFRAndStorage(AsyncProfilerCollectionMetaData taskMetaData, String fileName) throws IOException {
        AsyncProfilerTask task = taskMetaData.getTask();
        Arguments arguments = new Arguments();
        Map event2treeMap = JFRParser.dumpTree((String)fileName, (Arguments)arguments);
        for (Map.Entry entry : event2treeMap.entrySet()) {
            JFREventType event = (JFREventType)entry.getKey();
            FrameTree tree = (FrameTree)entry.getValue();
            JFRProfilingData data = new JFRProfilingData();
            data.setEventType(event);
            data.setFrameTree(tree);
            data.setTaskId(task.getId());
            data.setInstanceId(taskMetaData.getInstanceId());
            data.setUploadTime(taskMetaData.getUploadTime());
            this.sourceReceiver.receive((ISource)data);
        }
    }
}

