/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.scalar;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.InputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.utils.bean.BoolSetter;
import org.apache.servicecomb.foundation.common.utils.bean.Setter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;

public class BoolReadSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        JavaType javaType = propertyDescriptor.getJavaType();
        if (Boolean.TYPE.equals(javaType.getRawClass())) {
            return new BooleanPrimitiveSchema(protoField, propertyDescriptor);
        }
        if (Boolean.class.equals((Object)javaType.getRawClass()) || javaType.isJavaLangObject()) {
            return new BooleanSchema(protoField, propertyDescriptor);
        }
        ProtoUtils.throwNotSupportMerge(protoField, propertyDescriptor.getJavaType());
        return null;
    }

    private static class BooleanPrimitiveSchema<T>
    extends FieldSchema<T> {
        private final BoolSetter<T> setter;

        public BooleanPrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
            this.setter = (BoolSetter)propertyDescriptor.getSetter();
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            boolean value = input.readBool();
            this.setter.set(message, value);
            return input.readFieldNumber();
        }
    }

    private static class BooleanSchema<T>
    extends FieldSchema<T> {
        private final Setter<T, Boolean> setter;

        public BooleanSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
            this.setter = (Setter)propertyDescriptor.getSetter();
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            boolean value = input.readBool();
            this.setter.set(message, (Object)value);
            return input.readFieldNumber();
        }
    }
}

