/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.List;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.BrownCluster;
import opennlp.tools.util.featuregen.BrownTokenClasses;

public class BrownTokenFeatureGenerator
implements AdaptiveFeatureGenerator {
    private static final String PREFIX = "browncluster=";
    private final BrownCluster brownLexicon;

    public BrownTokenFeatureGenerator(BrownCluster dict) {
        this.brownLexicon = dict;
    }

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        List<String> wordClasses = BrownTokenClasses.getWordClasses(tokens[index], this.brownLexicon);
        for (String wordClass : wordClasses) {
            features.add(PREFIX + wordClass);
        }
    }
}

