/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.model.profile;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;

public class ConditionParser {
    private final Map<String, ExpressionFunction> functions;
    private final UnaryOperator<String> propertyResolver;
    private List<String> tokens;
    private int current;

    public ConditionParser(Map<String, ExpressionFunction> functions, UnaryOperator<String> propertyResolver) {
        this.functions = functions;
        this.propertyResolver = propertyResolver;
    }

    public Object parse(String expression) {
        this.tokens = this.tokenize(expression);
        this.current = 0;
        return this.parseExpression();
    }

    private List<String> tokenize(String expression) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        char quoteType = '\u0000';
        boolean inPropertyReference = false;
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (quoteType != '\u0000') {
                if (c == quoteType) {
                    quoteType = '\u0000';
                    sb.append(c);
                    tokens.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (inPropertyReference) {
                if (c == '}') {
                    inPropertyReference = false;
                    tokens.add("${" + String.valueOf(sb) + "}");
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == '$' && i + 1 < expression.length() && expression.charAt(i + 1) == '{') {
                if (!sb.isEmpty()) {
                    tokens.add(sb.toString());
                    sb.setLength(0);
                }
                inPropertyReference = true;
                ++i;
                continue;
            }
            if (c == '\"' || c == '\'') {
                if (!sb.isEmpty()) {
                    tokens.add(sb.toString());
                    sb.setLength(0);
                }
                quoteType = c;
                sb.append(c);
                continue;
            }
            if (c == ' ' || c == '(' || c == ')' || c == ',' || c == '+' || c == '>' || c == '<' || c == '=' || c == '!') {
                if (!sb.isEmpty()) {
                    tokens.add(sb.toString());
                    sb.setLength(0);
                }
                if (c == ' ') continue;
                if ((c == '>' || c == '<' || c == '=' || c == '!') && i + 1 < expression.length() && expression.charAt(i + 1) == '=') {
                    tokens.add(c + "=");
                    ++i;
                    continue;
                }
                tokens.add(String.valueOf(c));
                continue;
            }
            sb.append(c);
        }
        if (inPropertyReference) {
            throw new RuntimeException("Unclosed property reference: ${");
        }
        if (!sb.isEmpty()) {
            tokens.add(sb.toString());
        }
        return tokens;
    }

    private Object parseExpression() {
        Object result = this.parseLogicalOr();
        if (this.current < this.tokens.size()) {
            throw new RuntimeException("Unexpected tokens after end of expression");
        }
        return result;
    }

    private Object parseLogicalOr() {
        Object left = this.parseLogicalAnd();
        while (this.current < this.tokens.size() && this.tokens.get(this.current).equals("||")) {
            ++this.current;
            Object right = this.parseLogicalAnd();
            left = (Boolean)left != false || (Boolean)right != false;
        }
        return left;
    }

    private Object parseLogicalAnd() {
        Object left = this.parseComparison();
        while (this.current < this.tokens.size() && this.tokens.get(this.current).equals("&&")) {
            ++this.current;
            Object right = this.parseComparison();
            left = (Boolean)left != false && (Boolean)right != false;
        }
        return left;
    }

    private Object parseComparison() {
        Object left = this.parseAddSubtract();
        while (this.current < this.tokens.size() && (this.tokens.get(this.current).equals(">") || this.tokens.get(this.current).equals("<") || this.tokens.get(this.current).equals(">=") || this.tokens.get(this.current).equals("<=") || this.tokens.get(this.current).equals("==") || this.tokens.get(this.current).equals("!="))) {
            String operator = this.tokens.get(this.current);
            ++this.current;
            Object right = this.parseAddSubtract();
            left = ConditionParser.compare(left, operator, right);
        }
        return left;
    }

    private Object parseAddSubtract() {
        Object left = this.parseMultiplyDivide();
        while (this.current < this.tokens.size() && (this.tokens.get(this.current).equals("+") || this.tokens.get(this.current).equals("-"))) {
            String operator = this.tokens.get(this.current);
            ++this.current;
            Object right = this.parseMultiplyDivide();
            if (operator.equals("+")) {
                left = ConditionParser.add(left, right);
                continue;
            }
            left = ConditionParser.subtract(left, right);
        }
        return left;
    }

    private Object parseMultiplyDivide() {
        Object left = this.parseUnary();
        while (this.current < this.tokens.size() && (this.tokens.get(this.current).equals("*") || this.tokens.get(this.current).equals("/"))) {
            String operator = this.tokens.get(this.current);
            ++this.current;
            Object right = this.parseUnary();
            if (operator.equals("*")) {
                left = ConditionParser.multiply(left, right);
                continue;
            }
            left = ConditionParser.divide(left, right);
        }
        return left;
    }

    private Object parseUnary() {
        if (this.current < this.tokens.size() && this.tokens.get(this.current).equals("-")) {
            ++this.current;
            Object value = this.parseUnary();
            return this.negate(value);
        }
        return this.parseTerm();
    }

    private Object parseTerm() {
        if (this.current >= this.tokens.size()) {
            throw new RuntimeException("Unexpected end of expression");
        }
        String token = this.tokens.get(this.current);
        if (token.equals("(")) {
            return this.parseParentheses();
        }
        if (this.functions.containsKey(token)) {
            return this.parseFunction();
        }
        if (token.startsWith("\"") && token.endsWith("\"") || token.startsWith("'") && token.endsWith("'")) {
            ++this.current;
            return token.length() > 1 ? token.substring(1, token.length() - 1) : "";
        }
        if (token.equalsIgnoreCase("true") || token.equalsIgnoreCase("false")) {
            ++this.current;
            return Boolean.parseBoolean(token);
        }
        if (token.startsWith("${") && token.endsWith("}")) {
            ++this.current;
            String propertyName = token.substring(2, token.length() - 1);
            return this.propertyResolver.apply(propertyName);
        }
        try {
            ++this.current;
            return Double.parseDouble(token);
        }
        catch (NumberFormatException e) {
            return this.parseVariableOrUnknownFunction();
        }
    }

    private Object parseVariableOrUnknownFunction() {
        --this.current;
        String name = this.tokens.get(this.current);
        ++this.current;
        if (this.current < this.tokens.size() && this.tokens.get(this.current).equals("(")) {
            List<Object> args = this.parseArgumentList();
            if (this.functions.containsKey(name)) {
                return this.functions.get(name).apply(args);
            }
            throw new RuntimeException("Unknown function: " + name);
        }
        throw new RuntimeException("Unknown variable: " + name);
    }

    private List<Object> parseArgumentList() {
        ArrayList<Object> args = new ArrayList<Object>();
        ++this.current;
        while (this.current < this.tokens.size() && !this.tokens.get(this.current).equals(")")) {
            args.add(this.parseLogicalOr());
            if (this.current >= this.tokens.size() || !this.tokens.get(this.current).equals(",")) continue;
            ++this.current;
        }
        if (this.current >= this.tokens.size() || !this.tokens.get(this.current).equals(")")) {
            throw new RuntimeException("Mismatched parentheses: missing closing parenthesis in function call");
        }
        ++this.current;
        return args;
    }

    private Object parseFunction() {
        String functionName = this.tokens.get(this.current);
        ++this.current;
        List<Object> args = this.parseArgumentList();
        return this.functions.get(functionName).apply(args);
    }

    private Object parseParentheses() {
        ++this.current;
        Object result = this.parseLogicalOr();
        if (this.current >= this.tokens.size() || !this.tokens.get(this.current).equals(")")) {
            throw new RuntimeException("Mismatched parentheses: missing closing parenthesis");
        }
        ++this.current;
        return result;
    }

    private static Object add(Object left, Object right) {
        if (left instanceof String || right instanceof String) {
            return ConditionParser.toString(left) + ConditionParser.toString(right);
        }
        if (left instanceof Number) {
            Number leftNumber = (Number)left;
            if (right instanceof Number) {
                Number rightNumber = (Number)right;
                return leftNumber.doubleValue() + rightNumber.doubleValue();
            }
        }
        throw new RuntimeException("Cannot add " + String.valueOf(left) + " and " + String.valueOf(right));
    }

    private Object negate(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return -number.doubleValue();
        }
        throw new RuntimeException("Cannot negate non-numeric value: " + String.valueOf(value));
    }

    private static Object subtract(Object left, Object right) {
        if (left instanceof Number) {
            Number leftNumber = (Number)left;
            if (right instanceof Number) {
                Number rightNumber = (Number)right;
                return leftNumber.doubleValue() - rightNumber.doubleValue();
            }
        }
        throw new RuntimeException("Cannot subtract " + String.valueOf(right) + " from " + String.valueOf(left));
    }

    private static Object multiply(Object left, Object right) {
        if (left instanceof Number) {
            Number leftNumber = (Number)left;
            if (right instanceof Number) {
                Number rightNumber = (Number)right;
                return leftNumber.doubleValue() * rightNumber.doubleValue();
            }
        }
        throw new RuntimeException("Cannot multiply " + String.valueOf(left) + " and " + String.valueOf(right));
    }

    private static Object divide(Object left, Object right) {
        if (left instanceof Number) {
            Number leftNumber = (Number)left;
            if (right instanceof Number) {
                Number rightNumber = (Number)right;
                double divisor = rightNumber.doubleValue();
                if (divisor == 0.0) {
                    throw new ArithmeticException("Division by zero");
                }
                return leftNumber.doubleValue() / divisor;
            }
        }
        throw new RuntimeException("Cannot divide " + String.valueOf(left) + " by " + String.valueOf(right));
    }

    private static Object compare(Object left, String operator, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            if ("==".equals(operator)) {
                return false;
            }
            if ("!=".equals(operator)) {
                return true;
            }
        }
        if (left instanceof Number) {
            Number leftNumber = (Number)left;
            if (right instanceof Number) {
                Number rightNumber = (Number)right;
                double leftVal = leftNumber.doubleValue();
                double rightVal = rightNumber.doubleValue();
                return switch (operator) {
                    case ">" -> leftVal > rightVal;
                    case "<" -> leftVal < rightVal;
                    case ">=" -> leftVal >= rightVal;
                    case "<=" -> leftVal <= rightVal;
                    case "==" -> Math.abs(leftVal - rightVal) < 1.0E-9;
                    case "!=" -> Math.abs(leftVal - rightVal) >= 1.0E-9;
                    default -> throw new IllegalStateException("Unknown operator: " + operator);
                };
            }
        }
        if (left instanceof String) {
            String leftString = (String)left;
            if (right instanceof String) {
                String rightString = (String)right;
                int comparison = leftString.compareTo(rightString);
                return switch (operator) {
                    case ">" -> comparison > 0;
                    case "<" -> comparison < 0;
                    case ">=" -> comparison >= 0;
                    case "<=" -> comparison <= 0;
                    case "==" -> comparison == 0;
                    case "!=" -> comparison != 0;
                    default -> throw new IllegalStateException("Unknown operator: " + operator);
                };
            }
        }
        throw new RuntimeException("Cannot compare " + String.valueOf(left) + " and " + String.valueOf(right) + " with operator " + operator);
    }

    public static String toString(Object value) {
        double doubleValue;
        if ((value instanceof Double || value instanceof Float) && (doubleValue = ((Number)value).doubleValue()) == Math.floor(doubleValue) && !Double.isInfinite(doubleValue)) {
            return String.format("%.0f", doubleValue);
        }
        return String.valueOf(value);
    }

    public static Boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b;
        }
        if (value instanceof String) {
            String s = (String)value;
            return !s.isBlank();
        }
        if (value instanceof Number) {
            Number b = (Number)value;
            return b.intValue() != 0;
        }
        return value != null;
    }

    public static double toDouble(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Cannot convert string to number: " + String.valueOf(value));
            }
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool != false ? 1.0 : 0.0;
        }
        throw new RuntimeException("Cannot convert to number: " + String.valueOf(value));
    }

    public static int toInt(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                try {
                    return (int)Double.parseDouble((String)value);
                }
                catch (NumberFormatException e2) {
                    throw new RuntimeException("Cannot convert string to integer: " + String.valueOf(value));
                }
            }
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool != false ? 1 : 0;
        }
        throw new RuntimeException("Cannot convert to integer: " + String.valueOf(value));
    }

    public static interface ExpressionFunction {
        public Object apply(List<Object> var1);
    }
}

