/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.cassandra;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TimestampGenerator;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.cassandra.ClockTimestampGenerator;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseManager;
import org.apache.logging.log4j.core.appender.db.ColumnMapping;
import org.apache.logging.log4j.core.config.plugins.convert.DateTypeConverter;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverters;
import org.apache.logging.log4j.core.net.SocketAddress;
import org.apache.logging.log4j.spi.ThreadContextMap;
import org.apache.logging.log4j.spi.ThreadContextStack;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.Strings;

public class CassandraManager
extends AbstractDatabaseManager {
    private static final int DEFAULT_PORT = 9042;
    private final Cluster cluster;
    private final String keyspace;
    private final String insertQueryTemplate;
    private final List<ColumnMapping> columnMappings;
    private final BatchStatement batchStatement;
    private final Object[] values;
    private Session session;
    private PreparedStatement preparedStatement;

    private CassandraManager(String name, int bufferSize, Cluster cluster, String keyspace, String insertQueryTemplate, List<ColumnMapping> columnMappings, BatchStatement batchStatement) {
        super(name, bufferSize);
        this.cluster = cluster;
        this.keyspace = keyspace;
        this.insertQueryTemplate = insertQueryTemplate;
        this.columnMappings = columnMappings;
        this.batchStatement = batchStatement;
        this.values = new Object[columnMappings.size()];
    }

    protected void startupInternal() throws Exception {
        this.session = this.cluster.connect(this.keyspace);
        this.preparedStatement = this.session.prepare(this.insertQueryTemplate);
    }

    protected boolean shutdownInternal() throws Exception {
        this.session.close();
        this.cluster.close();
        return true;
    }

    protected void connectAndStart() {
    }

    protected void writeInternal(LogEvent event, Serializable serializable) {
        for (int i = 0; i < this.columnMappings.size(); ++i) {
            ColumnMapping columnMapping = this.columnMappings.get(i);
            this.values[i] = ThreadContextMap.class.isAssignableFrom(columnMapping.getType()) || ReadOnlyStringMap.class.isAssignableFrom(columnMapping.getType()) ? event.getContextData().toMap() : (ThreadContextStack.class.isAssignableFrom(columnMapping.getType()) ? event.getContextStack().asList() : (Date.class.isAssignableFrom(columnMapping.getType()) ? DateTypeConverter.fromMillis((long)event.getTimeMillis(), columnMapping.getType().asSubclass(Date.class)) : TypeConverters.convert((String)((String)((Object)columnMapping.getLayout().toSerializable(event))), (Class)columnMapping.getType(), null)));
        }
        BoundStatement boundStatement = this.preparedStatement.bind(this.values);
        if (this.batchStatement == null) {
            this.session.execute((Statement)boundStatement);
        } else {
            this.batchStatement.add((Statement)boundStatement);
        }
    }

    protected boolean commitAndClose() {
        if (this.batchStatement != null) {
            this.session.execute((Statement)this.batchStatement);
        }
        return true;
    }

    public static CassandraManager getManager(String name, SocketAddress[] contactPoints, ColumnMapping[] columns, boolean useTls, String clusterName, String keyspace, String table, String username, String password, boolean useClockForTimestampGenerator, int bufferSize, boolean batched, BatchStatement.Type batchType) {
        return (CassandraManager)CassandraManager.getManager((String)name, (AbstractDatabaseManager.AbstractFactoryData)new FactoryData(contactPoints, columns, useTls, clusterName, keyspace, table, username, password, useClockForTimestampGenerator, bufferSize, batched, batchType), (ManagerFactory)CassandraManagerFactory.INSTANCE);
    }

    private static final class FactoryData
    extends AbstractDatabaseManager.AbstractFactoryData {
        private final InetSocketAddress[] contactPoints;
        private final ColumnMapping[] columns;
        private final boolean useTls;
        private final String clusterName;
        private final String keyspace;
        private final String table;
        private final String username;
        private final String password;
        private final boolean useClockForTimestampGenerator;
        private final boolean batched;
        private final BatchStatement.Type batchType;

        private FactoryData(SocketAddress[] contactPoints, ColumnMapping[] columns, boolean useTls, String clusterName, String keyspace, String table, String username, String password, boolean useClockForTimestampGenerator, int bufferSize, boolean batched, BatchStatement.Type batchType) {
            super(bufferSize, null);
            this.contactPoints = FactoryData.convertAndAddDefaultPorts(contactPoints);
            this.columns = columns;
            this.useTls = useTls;
            this.clusterName = clusterName;
            this.keyspace = keyspace;
            this.table = table;
            this.username = username;
            this.password = password;
            this.useClockForTimestampGenerator = useClockForTimestampGenerator;
            this.batched = batched;
            this.batchType = batchType;
        }

        private static InetSocketAddress[] convertAndAddDefaultPorts(SocketAddress ... socketAddresses) {
            InetSocketAddress[] inetSocketAddresses = new InetSocketAddress[socketAddresses.length];
            for (int i = 0; i < inetSocketAddresses.length; ++i) {
                SocketAddress socketAddress = socketAddresses[i];
                inetSocketAddresses[i] = socketAddress.getPort() == 0 ? new InetSocketAddress(socketAddress.getAddress(), 9042) : socketAddress.getSocketAddress();
            }
            return inetSocketAddresses;
        }
    }

    private static class CassandraManagerFactory
    implements ManagerFactory<CassandraManager, FactoryData> {
        private static final CassandraManagerFactory INSTANCE = new CassandraManagerFactory();

        private CassandraManagerFactory() {
        }

        public CassandraManager createManager(String name, FactoryData data) {
            Cluster.Builder builder = Cluster.builder().addContactPointsWithPorts(data.contactPoints).withClusterName(data.clusterName);
            if (data.useTls) {
                builder.withSSL();
            }
            if (Strings.isNotBlank((String)data.username)) {
                builder.withCredentials(data.username, data.password);
            }
            if (data.useClockForTimestampGenerator) {
                builder.withTimestampGenerator((TimestampGenerator)new ClockTimestampGenerator());
            }
            Cluster cluster = builder.build();
            StringBuilder sb = new StringBuilder("INSERT INTO ").append(data.table).append(" (");
            for (ColumnMapping column : data.columns) {
                sb.append(column.getName()).append(',');
            }
            sb.setCharAt(sb.length() - 1, ')');
            sb.append(" VALUES (");
            ArrayList<ColumnMapping> columnMappings = new ArrayList<ColumnMapping>(data.columns.length);
            for (ColumnMapping column : data.columns) {
                if (Strings.isNotEmpty((CharSequence)column.getLiteralValue())) {
                    sb.append(column.getLiteralValue());
                } else {
                    sb.append('?');
                    columnMappings.add(column);
                }
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, ')');
            String insertQueryTemplate = sb.toString();
            LOGGER.debug("Using CQL for appender {}: {}", (Object)name, (Object)insertQueryTemplate);
            return new CassandraManager(name, data.getBufferSize(), cluster, data.keyspace, insertQueryTemplate, columnMappings, data.batched ? new BatchStatement(data.batchType) : null);
        }
    }
}

