/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.junit;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import org.apache.logging.log4j.test.internal.annotation.SuppressFBWarnings;
import org.apache.logging.log4j.test.junit.AbstractFileCleaner;
import org.apache.logging.log4j.test.junit.CleanUpFiles;
import org.junit.jupiter.api.extension.ExtensionContext;

class FileCleaner
extends AbstractFileCleaner {
    FileCleaner() {
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    Collection<Path> getPathsForTest(ExtensionContext context) {
        CleanUpFiles testMethodAnnotation;
        HashSet<Path> paths = new HashSet<Path>();
        CleanUpFiles testClassAnnotation = context.getRequiredTestClass().getAnnotation(CleanUpFiles.class);
        if (testClassAnnotation != null) {
            for (String path : testClassAnnotation.value()) {
                paths.add(Paths.get(path, new String[0]));
            }
        }
        if ((testMethodAnnotation = context.getRequiredTestMethod().getAnnotation(CleanUpFiles.class)) != null) {
            for (String path : testMethodAnnotation.value()) {
                paths.add(Paths.get(path, new String[0]));
            }
        }
        return paths;
    }

    @Override
    boolean delete(Path path) throws IOException {
        return Files.deleteIfExists(path);
    }
}

