/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class CommonGramsTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final List<String> commonWords;
    @Nullable
    private final String commonWordsPath;
    @Nullable
    private final Boolean ignoreCase;
    @Nullable
    private final Boolean queryMode;
    public static final JsonpDeserializer<CommonGramsTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CommonGramsTokenFilter::setupCommonGramsTokenFilterDeserializer);

    private CommonGramsTokenFilter(Builder builder) {
        super(builder);
        this.commonWords = ApiTypeHelper.unmodifiable(builder.commonWords);
        this.commonWordsPath = builder.commonWordsPath;
        this.ignoreCase = builder.ignoreCase;
        this.queryMode = builder.queryMode;
    }

    public static CommonGramsTokenFilter of(Function<Builder, ObjectBuilder<CommonGramsTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.CommonGrams;
    }

    public final List<String> commonWords() {
        return this.commonWords;
    }

    @Nullable
    public final String commonWordsPath() {
        return this.commonWordsPath;
    }

    @Nullable
    public final Boolean ignoreCase() {
        return this.ignoreCase;
    }

    @Nullable
    public final Boolean queryMode() {
        return this.queryMode;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "common_grams");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.commonWords)) {
            generator.writeKey("common_words");
            generator.writeStartArray();
            for (String item0 : this.commonWords) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.commonWordsPath != null) {
            generator.writeKey("common_words_path");
            generator.write(this.commonWordsPath);
        }
        if (this.ignoreCase != null) {
            generator.writeKey("ignore_case");
            generator.write(this.ignoreCase.booleanValue());
        }
        if (this.queryMode != null) {
            generator.writeKey("query_mode");
            generator.write(this.queryMode.booleanValue());
        }
    }

    protected static void setupCommonGramsTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::commonWords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "common_words");
        op.add(Builder::commonWordsPath, JsonpDeserializer.stringDeserializer(), "common_words_path");
        op.add(Builder::ignoreCase, JsonpDeserializer.booleanDeserializer(), "ignore_case");
        op.add(Builder::queryMode, JsonpDeserializer.booleanDeserializer(), "query_mode");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CommonGramsTokenFilter> {
        @Nullable
        private List<String> commonWords;
        @Nullable
        private String commonWordsPath;
        @Nullable
        private Boolean ignoreCase;
        @Nullable
        private Boolean queryMode;

        public final Builder commonWords(List<String> list) {
            this.commonWords = Builder._listAddAll(this.commonWords, list);
            return this;
        }

        public final Builder commonWords(String value, String ... values) {
            this.commonWords = Builder._listAdd(this.commonWords, value, values);
            return this;
        }

        public final Builder commonWordsPath(@Nullable String value) {
            this.commonWordsPath = value;
            return this;
        }

        public final Builder ignoreCase(@Nullable Boolean value) {
            this.ignoreCase = value;
            return this;
        }

        public final Builder queryMode(@Nullable Boolean value) {
            this.queryMode = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CommonGramsTokenFilter build() {
            this._checkSingleUse();
            return new CommonGramsTokenFilter(this);
        }
    }
}

