# TECATOR dataset
# The purpose of this dataset is to measure the fat content of meat based off its near infrared absorbance spectrum.
# The absorbance spectrum is measured in the wavelength range of 850 nm to 1050 nm.
# The fat content is measured by standard chemical analysis methods.
# The dataset contains 215 samples of meat, each with 100 spectral measurements.
# For more information see: https://www.openml.org/search?type=data&sort=runs&id=505&status=active
# References:
# [1] C.Borggaard and H.H.Thodberg, "Optimal Minimal Neural Interpretation of Spectra", Analytical Chemistry 64 (1992), p 545-551.
# [2] H.H.Thodberg, "Ace of Bayes: Application of Neural Networks with Pruning" Manuscript 1132, Danish Meat Research Institute (1993)

@problemName TECATOR
@timeStamps false
@missing false
@univariate true
@equalLength true
@targetLabel true
@data
2.91042,2.91224,2.91419,2.91639,2.9189,2.92185,2.92538,2.92956,2.93438,2.94,2.94634,2.95354,2.96176,2.97117,2.98193,2.99411,3.00767,3.0227,3.0392,3.05696,3.07544,3.09366,3.11071,3.1262,3.14052,3.15459,3.16998,3.18836,3.21061,3.23699,3.2667,3.29807,3.32934,3.35954,3.3891,3.41952,3.45203,3.48575,3.51835,3.5466,3.56697,3.57646,3.57384,3.56064,3.54114,3.52105,3.50589,3.50111,3.508,3.52723,3.55833,3.59951,3.64751,3.69765,3.74477,3.78466,3.81523,3.8369,3.85168,3.86166,3.86871,3.87382,3.87724,3.87893,3.87869,3.87641,3.87222,3.8663,3.85894,3.85044,3.84093,3.83057,3.81947,3.80779,3.79545,3.78248,3.76899,3.7555,3.74245,3.72989,3.71769,3.70547,3.69275,3.67895,3.66339,3.64573,3.62625,3.60585,3.58577,3.5669,3.54949,3.53316,3.51721,3.50109,3.48442,3.46696,3.44816,3.42762,3.40528,3.38148:46.3
2.83385,2.83706,2.84025,2.84353,2.84703,2.85084,2.85502,2.8596,2.86457,2.87001,2.87591,2.88228,2.88928,2.89703,2.90555,2.91488,2.925,2.93611,2.94829,2.96146,2.9753,2.98929,3.00285,3.01566,3.02792,3.04009,3.05299,3.06774,3.08502,3.10489,3.1268,3.14964,3.17232,3.19434,3.21607,3.23847,3.2622,3.28646,3.30951,3.32916,3.34315,3.34967,3.34815,3.33973,3.32718,3.3143,3.30479,3.30234,3.3081,3.32257,3.34534,3.3751,3.40934,3.4447,3.47759,3.50507,3.52568,3.53965,3.54843,3.55349,3.55611,3.55724,3.55709,3.55568,3.55286,3.54852,3.54273,3.5357,3.52771,3.51896,3.50954,3.49962,3.48927,3.47859,3.46763,3.45633,3.44492,3.4337,3.42299,3.41284,3.40307,3.39331,3.38322,3.37246,3.36065,3.34758,3.33347,3.31892,3.30467,3.29126,3.27883,3.26711,3.25563,3.24407,3.23212,3.21955,3.2061,3.19153,3.17575,3.15905:47.7
2.78079,2.78273,2.78479,2.78699,2.78944,2.79224,2.7954,2.79891,2.80277,2.807,2.81182,2.81717,2.82306,2.82959,2.83679,2.84468,2.8533,2.86262,2.87271,2.8832,2.89354,2.90344,2.91275,2.92164,2.93048,2.9397,2.9499,2.96168,2.97516,2.98992,3.00535,3.02091,3.03647,3.05247,3.06965,3.08851,3.10913,3.13084,3.1522,3.1719,3.18879,3.20247,3.21348,3.22333,3.23417,3.24829,3.26777,3.29427,3.32934,3.37279,3.42346,3.47874,3.53449,3.58595,3.62923,3.66246,3.68608,3.70215,3.71302,3.72047,3.72559,3.72863,3.72971,3.72866,3.7254,3.71993,3.71236,3.70294,3.69193,3.67951,3.66585,3.65104,3.6352,3.61843,3.60092,3.58283,3.56431,3.54564,3.52687,3.50802,3.48889,3.46939,3.44925,3.42825,3.40631,3.38358,3.36051,3.33764,3.31542,3.29395,3.27314,3.25278,3.23275,3.21297,3.19336,3.17388,3.15438,3.13476,3.11509,3.09565:25.5
2.5739,2.57476,2.57555,2.57644,2.57734,2.57839,2.57962,2.58103,2.58266,2.58443,2.58649,2.58883,2.5914,2.59421,2.59732,2.60078,2.60459,2.60876,2.61334,2.61822,2.62334,2.62844,2.63344,2.63824,2.64285,2.64742,2.6521,2.65704,2.66234,2.66806,2.67404,2.68017,2.68654,2.69345,2.70138,2.71077,2.72193,2.73491,2.74949,2.7653,2.78182,2.79868,2.81573,2.83339,2.85238,2.87373,2.89855,2.92792,2.96273,3.00354,3.05019,3.1013,3.15401,3.20379,3.2461,3.27912,3.30329,3.32044,3.33271,3.3417,3.34841,3.35325,3.35628,3.35738,3.35642,3.35337,3.34828,3.34129,3.33247,3.32204,3.31007,3.29671,3.28215,3.26635,3.24957,3.23195,3.21367,3.19486,3.17555,3.15578,3.13547,3.1146,3.09307,3.07083,3.04792,3.02444,3.00066,2.97695,2.95356,2.93055,2.90784,2.88545,2.8634,2.8418,2.82073,2.80025,2.78029,2.76085,2.74186,2.72338:10.6
2.19217,2.19194,2.19171,2.19145,2.19119,2.19103,2.19104,2.1912,2.19145,2.19189,2.19249,2.19321,2.1941,2.19519,2.19645,2.19783,2.1994,2.20129,2.20351,2.20599,2.20865,2.21141,2.21423,2.21712,2.22003,2.22288,2.22567,2.22831,2.23082,2.23325,2.23571,2.23826,2.24109,2.24451,2.24892,2.25478,2.26264,2.27259,2.28467,2.29884,2.31506,2.33321,2.35317,2.37487,2.39831,2.42368,2.45147,2.48271,2.51801,2.55812,2.60317,2.6524,2.70369,2.75371,2.79878,2.83598,2.86432,2.88472,2.89911,2.90935,2.91687,2.92257,2.92655,2.92871,2.92894,2.92716,2.92336,2.91766,2.91022,2.90114,2.89056,2.87859,2.86535,2.85098,2.8357,2.81951,2.80262,2.78518,2.76722,2.74885,2.73009,2.71089,2.69116,2.67094,2.65025,2.62919,2.60792,2.5866,2.56538,2.54438,2.52357,2.50304,2.4829,2.46319,2.44407,2.4256,2.40785,2.39088,2.37466,2.35912:2.0
2.58878,2.59457,2.60029,2.60591,2.61148,2.61697,2.62238,2.62785,2.63335,2.63882,2.64424,2.64962,2.65506,2.66056,2.66607,2.6716,2.67711,2.68272,2.68843,2.69427,2.7002,2.70614,2.71207,2.71795,2.72379,2.72961,2.73536,2.74099,2.74655,2.75209,2.75767,2.7633,2.76904,2.77504,2.78156,2.78887,2.7974,2.80725,2.81838,2.83072,2.84419,2.85869,2.87409,2.89035,2.90752,2.92574,2.9454,2.96739,2.99218,3.02032,3.05209,3.08718,3.12441,3.16167,3.19643,3.22642,3.25031,3.26818,3.28097,3.29008,3.29665,3.30141,3.30466,3.30636,3.30645,3.30488,3.3017,3.29701,3.29088,3.28342,3.27475,3.265,3.25427,3.24276,3.23055,3.21765,3.20415,3.19025,3.17609,3.16165,3.14698,3.13205,3.11677,3.1011,3.08508,3.06882,3.05239,3.03588,3.0194,3.00307,2.98695,2.971,2.95528,2.93982,2.92464,2.9098,2.89538,2.88134,2.86766,2.85427:4.7
2.55331,2.55364,2.55392,2.55425,2.55462,2.55506,2.55561,2.55631,2.5572,2.5583,2.55962,2.56117,2.56288,2.56475,2.56686,2.56923,2.57182,2.57468,2.57791,2.5814,2.58511,2.58896,2.59287,2.59678,2.60064,2.60439,2.60815,2.612,2.61596,2.62007,2.62433,2.6287,2.63322,2.63807,2.6435,2.64996,2.65782,2.6676,2.67914,2.69238,2.70712,2.72306,2.74003,2.75797,2.77697,2.79738,2.81979,2.84492,2.87412,2.90812,2.94749,2.99206,3.0404,3.08953,3.13562,3.17516,3.20611,3.22841,3.24358,3.2537,3.2604,3.26473,3.26718,3.26783,3.26661,3.2634,3.25812,3.25085,3.24179,3.23113,3.21897,3.20545,3.19075,3.17492,3.15814,3.1405,3.12215,3.10324,3.08394,3.06434,3.04444,3.02421,3.00359,2.98251,2.96102,2.93911,2.91684,2.89442,2.87211,2.85013,2.8285,2.80723,2.7863,2.76575,2.74566,2.72617,2.70738,2.68926,2.67178,2.65484:6.8
2.84297,2.84677,2.85048,2.85414,2.85778,2.86148,2.86523,2.86905,2.87294,2.87691,2.88097,2.8851,2.8893,2.8936,2.89804,2.90262,2.90732,2.91215,2.91715,2.92233,2.92762,2.9329,2.93806,2.94304,2.94785,2.95245,2.95692,2.96132,2.96584,2.97054,2.97534,2.98007,2.98474,2.98963,2.99524,3.00201,3.01021,3.01991,3.03106,3.04338,3.05652,3.07003,3.08363,3.09737,3.11169,3.12738,3.14542,3.16678,3.19235,3.22292,3.2589,3.29947,3.34237,3.38394,3.42042,3.44955,3.4711,3.48657,3.49787,3.50652,3.51331,3.51866,3.52265,3.52516,3.52606,3.52521,3.52259,3.51828,3.51242,3.50509,3.49641,3.4864,3.47515,3.46277,3.44931,3.43489,3.41964,3.40375,3.38733,3.37038,3.35289,3.33483,3.31614,3.29673,3.27654,3.25559,3.23406,3.21229,3.1906,3.1691,3.14778,3.12655,3.10541,3.08446,3.06387,3.04372,3.02398,3.00454,2.98533,2.96638:8.6
2.48686,2.4818,2.47689,2.47213,2.46752,2.46308,2.4589,2.45508,2.45155,2.44836,2.44548,2.44293,2.44076,2.43899,2.43762,2.43655,2.43582,2.43553,2.43571,2.43627,2.43717,2.43831,2.43959,2.44096,2.44245,2.44407,2.4459,2.44811,2.45097,2.45449,2.45865,2.46335,2.46851,2.47431,2.48121,2.48979,2.50071,2.51378,2.52872,2.5451,2.56244,2.58025,2.59813,2.61604,2.63445,2.65429,2.67678,2.70365,2.73566,2.77351,2.81731,2.8662,2.91796,2.96917,3.01591,3.05497,3.08492,3.10651,3.12157,3.13206,3.13961,3.14501,3.14855,3.15014,3.14973,3.14727,3.14271,3.13612,3.12767,3.11755,3.10597,3.09305,3.07886,3.06355,3.04721,3.03,3.01201,2.99357,2.97474,2.95553,2.93594,2.91591,2.89548,2.87461,2.85321,2.83133,2.80914,2.78691,2.76492,2.74336,2.72234,2.70186,2.68188,2.66234,2.64331,2.62492,2.60712,2.58987,2.57305,2.55666:11.2
2.418,2.41326,2.40866,2.40415,2.39977,2.3956,2.39173,2.38817,2.38485,2.38189,2.37929,2.37703,2.37512,2.37357,2.3724,2.37161,2.37123,2.37129,2.3718,2.37265,2.37383,2.37527,2.37687,2.37856,2.38034,2.38217,2.38433,2.38701,2.39044,2.39472,2.39974,2.4053,2.41134,2.41802,2.42572,2.43506,2.44666,2.46033,2.47571,2.49226,2.50931,2.52622,2.54257,2.55841,2.5744,2.59162,2.61153,2.63592,2.66565,2.70138,2.74318,2.79008,2.83987,2.88918,2.93417,2.97177,3.00072,3.02165,3.03633,3.04658,3.05397,3.05934,3.06288,3.06464,3.06441,3.0621,3.05772,3.05148,3.04349,3.03385,3.02278,3.0104,2.99686,2.98221,2.96656,2.95007,2.93287,2.91522,2.8971,2.87873,2.85994,2.8408,2.82128,2.80131,2.78077,2.75969,2.73821,2.71668,2.69547,2.67474,2.65457,2.63493,2.61572,2.59702,2.57887,2.56125,2.54406,2.52722,2.51069,2.4946:13.8
2.23632,2.23328,2.23031,2.22744,2.22472,2.22221,2.22,2.21809,2.21649,2.21521,2.21429,2.21374,2.21362,2.21397,2.21489,2.21635,2.21837,2.22095,2.22415,2.22791,2.23199,2.23603,2.23978,2.24319,2.24646,2.24984,2.25364,2.25823,2.26398,2.27089,2.27864,2.28663,2.29453,2.3026,2.31158,2.3222,2.3348,2.34926,2.36514,2.3816,2.39766,2.41241,2.42555,2.43748,2.44942,2.46303,2.47993,2.50152,2.52877,2.56248,2.60301,2.64947,2.69953,2.74941,2.7948,2.83264,2.86184,2.88333,2.89896,2.91041,2.91892,2.92524,2.92962,2.932,2.93225,2.93027,2.92613,2.91999,2.91199,2.90235,2.89126,2.87884,2.86526,2.85061,2.83497,2.81847,2.80131,2.78378,2.76605,2.74817,2.73009,2.71174,2.69305,2.67383,2.65383,2.63304,2.61173,2.59043,2.56961,2.54949,2.53004,2.51109,2.49255,2.47444,2.45685,2.43978,2.42305,2.40649,2.39006,2.37389:17.7
2.93533,2.93565,2.93599,2.93649,2.93722,2.93821,2.93953,2.94132,2.94357,2.94635,2.94968,2.95352,2.95794,2.96301,2.96881,2.97537,2.98274,2.99098,3.00009,3.00997,3.02037,3.03085,3.04103,3.0507,3.05991,3.06903,3.07863,3.0894,3.10171,3.11574,3.13118,3.14747,3.16404,3.18072,3.19805,3.21697,3.23843,3.26218,3.28736,3.31266,3.33668,3.35819,3.37658,3.39222,3.40656,3.42199,3.44117,3.46732,3.5017,3.5453,3.5983,3.65964,3.7265,3.79415,3.85683,3.90947,3.94932,3.97701,3.99516,4.00683,4.01428,4.01875,4.0209,4.02072,4.01795,4.01255,4.00451,3.994,3.98126,3.96659,3.95029,3.93246,3.91326,3.89286,3.87148,3.84928,3.82639,3.80305,3.77962,3.75628,3.73285,3.70912,3.68485,3.65989,3.63403,3.60723,3.57968,3.55181,3.52422,3.49743,3.47158,3.44649,3.42192,3.39776,3.37404,3.35068,3.32751,3.30448,3.28137,3.25845:23.3
3.10191,3.10588,3.10988,3.11395,3.11808,3.12238,3.12691,3.13173,3.13697,3.14254,3.14837,3.15457,3.16129,3.16859,3.17648,3.1849,3.19382,3.20347,3.21397,3.22524,3.23709,3.24932,3.26161,3.27361,3.28507,3.29607,3.30708,3.31893,3.33226,3.34733,3.36388,3.38128,3.39886,3.41633,3.43401,3.45262,3.47311,3.49598,3.52025,3.54434,3.56642,3.58483,3.59843,3.60715,3.61224,3.61609,3.62177,3.63234,3.65086,3.67805,3.71405,3.7581,3.80814,3.86049,3.91054,3.954,3.98839,4.01361,4.03118,4.04332,4.05181,4.05775,4.06198,4.0643,4.06478,4.06308,4.05928,4.05343,4.04572,4.03645,4.02578,4.01384,4.00075,3.98658,3.9715,3.95542,3.93876,3.92167,3.90444,3.88721,3.86988,3.85248,3.83478,3.81636,3.79682,3.77595,3.75396,3.73134,3.70873,3.68666,3.66544,3.64501,3.62509,3.60538,3.58573,3.56619,3.5466,3.52658,3.50584,3.48451:29.0
4.21506,4.22527,4.23556,4.24588,4.25643,4.26727,4.27837,4.28978,4.3015,4.31379,4.3266,4.33978,4.35348,4.36789,4.38311,4.39911,4.41585,4.43347,4.45195,4.47157,4.49199,4.5127,4.53306,4.55264,4.57153,4.59008,4.60894,4.62943,4.65202,4.67684,4.7032,4.73033,4.75771,4.78492,4.81184,4.83944,4.86814,4.89901,4.93018,4.95934,4.98424,5.00296,5.01484,5.02054,5.02147,5.02169,5.02523,5.03657,5.05663,5.08597,5.12523,5.17332,5.22716,5.28189,5.33227,5.37438,5.40621,5.42798,5.44268,5.45358,5.46192,5.46703,5.47086,5.47339,5.47374,5.47094,5.46518,5.45833,5.45074,5.44102,5.4293,5.41587,5.40228,5.38922,5.37368,5.3566,5.33971,5.32278,5.30455,5.2867,5.27026,5.25309,5.23453,5.21448,5.1942,5.17313,5.14989,5.12529,5.10037,5.07625,5.05386,5.0324,5.01149,4.98981,4.96771,4.94535,4.92276,4.89965,4.87567,4.85102:34.8
2.89064,2.89244,2.89438,2.89659,2.89913,2.90211,2.90566,2.90982,2.91468,2.92031,2.92672,2.93393,2.94215,2.95162,2.96246,2.97468,2.98837,3.00351,3.02017,3.03799,3.05637,3.07442,3.09126,3.10649,3.12049,3.13426,3.14938,3.1674,3.18931,3.21534,3.24464,3.27559,3.30644,3.33614,3.36509,3.39483,3.42658,3.45948,3.49127,3.51876,3.53835,3.547,3.5435,3.52941,3.50883,3.48751,3.47102,3.46452,3.46957,3.48671,3.51552,3.55417,3.59944,3.64683,3.69145,3.72932,3.75847,3.77923,3.79343,3.80307,3.80985,3.81487,3.81816,3.81992,3.81981,3.81779,3.81395,3.80847,3.80162,3.79364,3.78474,3.77509,3.7647,3.7537,3.74201,3.72972,3.71702,3.70437,3.69211,3.68038,3.66899,3.65755,3.64566,3.63274,3.6181,3.60131,3.58258,3.56287,3.5435,3.52541,3.50878,3.49314,3.47783,3.46234,3.44632,3.42949,3.41136,3.39146,3.36959,3.34622:47.8
3.63719,3.64846,3.65957,3.67057,3.68146,3.69229,3.70307,3.71379,3.72457,3.73542,3.74623,3.75713,3.76805,3.77902,3.79008,3.80124,3.81262,3.82412,3.8358,3.84772,3.85974,3.87184,3.88394,3.89596,3.90781,3.91942,3.93098,3.94257,3.95437,3.96637,3.9785,3.99067,4.00286,4.01513,4.02787,4.04137,4.05612,4.07219,4.08947,4.10781,4.12676,4.14594,4.16516,4.18443,4.20405,4.22462,4.24696,4.27225,4.30128,4.33467,4.37272,4.41516,4.46056,4.50655,4.55016,4.58851,4.61978,4.64389,4.6622,4.6758,4.68574,4.69328,4.69888,4.70273,4.70457,4.70444,4.70241,4.69832,4.69216,4.68431,4.67511,4.66479,4.65323,4.64045,4.62661,4.61193,4.59671,4.58119,4.5655,4.54925,4.53268,4.51576,4.49862,4.48107,4.46308,4.44466,4.42587,4.4069,4.38806,4.36966,4.35176,4.33413,4.31666,4.29959,4.28297,4.26668,4.25065,4.23491,4.21959,4.20452:11.1
2.88841,2.89612,2.90365,2.91112,2.91849,2.9258,2.93305,2.94026,2.94758,2.95479,2.96199,2.96915,2.97629,2.98345,2.99066,2.99786,3.00509,3.01239,3.01979,3.02726,3.03478,3.04228,3.04975,3.05717,3.0645,3.07174,3.07889,3.08585,3.09261,3.09925,3.10582,3.1123,3.11879,3.12548,3.13253,3.14018,3.14885,3.15851,3.16929,3.18116,3.19405,3.20791,3.22266,3.23827,3.25478,3.27232,3.29121,3.31209,3.33552,3.36191,3.39153,3.42403,3.45826,3.49226,3.52367,3.55044,3.57162,3.58746,3.59899,3.60745,3.61372,3.61844,3.62181,3.62383,3.62442,3.62355,3.6212,3.6174,3.61231,3.60604,3.59863,3.59021,3.58088,3.57073,3.55985,3.54833,3.53635,3.52394,3.51121,3.49822,3.48495,3.47135,3.45745,3.44325,3.42874,3.41397,3.39902,3.38402,3.36908,3.35426,3.3396,3.3251,3.31075,3.29666,3.28288,3.26947,3.25639,3.24368,3.23138,3.21932:2.9
2.2865,2.28699,2.28749,2.28799,2.28851,2.28908,2.28977,2.29066,2.29165,2.29279,2.2941,2.29556,2.29717,2.29893,2.30087,2.30301,2.3054,2.30801,2.31098,2.3142,2.31759,2.32107,2.32462,2.32821,2.33184,2.33549,2.33914,2.34275,2.34643,2.35016,2.35399,2.35796,2.36215,2.36678,2.37228,2.37903,2.38759,2.39795,2.41014,2.42413,2.43975,2.45682,2.4752,2.49481,2.51578,2.53837,2.56322,2.59134,2.62334,2.6599,2.70126,2.74683,2.79483,2.84228,2.88563,2.92194,2.94992,2.97009,2.98427,2.9942,3.00128,3.00649,3.00995,3.01171,3.01165,3.00967,3.00581,3.00016,2.99281,2.9839,2.97368,2.96225,2.94969,2.93613,2.9217,2.90655,2.89077,2.87453,2.85801,2.84116,2.82403,2.80653,2.78868,2.77049,2.75187,2.73291,2.7137,2.69445,2.67542,2.65667,2.63822,2.62009,2.60229,2.5849,2.56798,2.55165,2.53597,2.52102,2.50662,2.49281:4.8
2.62979,2.632,2.63413,2.63626,2.63846,2.64072,2.64303,2.64548,2.648,2.65065,2.65346,2.6564,2.65947,2.66264,2.66592,2.6694,2.67302,2.67689,2.68095,2.68514,2.68946,2.69387,2.69828,2.70267,2.70697,2.71114,2.71522,2.71923,2.72323,2.72725,2.73128,2.73533,2.73948,2.74393,2.74898,2.755,2.76246,2.77138,2.78171,2.79331,2.806,2.81959,2.83391,2.84895,2.86486,2.88209,2.90118,2.92336,2.94913,2.97917,3.01363,3.0519,3.09222,3.13179,3.16746,3.19675,3.21871,3.23405,3.24441,3.25133,3.25598,3.25903,3.26062,3.26066,3.25909,3.25586,3.25095,3.24435,3.23616,3.22654,3.2156,3.20347,3.19022,3.17585,3.16056,3.14436,3.12748,3.11004,3.09214,3.07381,3.05504,3.03578,3.01601,2.99572,2.97493,2.95364,2.93202,2.91024,2.8885,2.86696,2.84566,2.82459,2.80375,2.78326,2.7632,2.74361,2.72461,2.70611,2.6881,2.67051:5.6
2.61033,2.61247,2.61469,2.61696,2.61926,2.62165,2.62417,2.62684,2.62977,2.6329,2.63616,2.6396,2.64323,2.64709,2.65115,2.65541,2.65986,2.66458,2.66962,2.67491,2.68041,2.68605,2.69175,2.6974,2.70302,2.70861,2.71415,2.71969,2.72523,2.73082,2.73648,2.74224,2.74813,2.75434,2.76115,2.76893,2.7783,2.78926,2.80179,2.81573,2.83079,2.84675,2.86347,2.88089,2.89914,2.91863,2.94004,2.96454,2.99285,3.02579,3.0637,3.10612,3.15131,3.19623,3.23717,3.27093,3.29592,3.31265,3.32292,3.32865,3.33137,3.33212,3.33113,3.32841,3.32376,3.31713,3.30857,3.29814,3.28594,3.27217,3.257,3.24055,3.22289,3.2042,3.18459,3.16427,3.14326,3.1218,3.10003,3.07788,3.05545,3.03269,3.00952,2.98597,2.962,2.93764,2.91304,2.8884,2.86396,2.83988,2.8162,2.79291,2.77001,2.74757,2.72574,2.70455,2.68405,2.6642,2.645,2.62642:6.2
2.2863,2.28689,2.28745,2.288,2.28864,2.2894,2.29022,2.29114,2.29227,2.29358,2.29504,2.29669,2.29849,2.30044,2.30259,2.30498,2.30761,2.31047,2.31365,2.31709,2.3207,2.32442,2.32817,2.33185,2.33547,2.33904,2.34265,2.3463,2.35009,2.35395,2.35791,2.36202,2.36636,2.37116,2.37677,2.38359,2.39209,2.40235,2.4143,2.42779,2.4426,2.45849,2.47529,2.49301,2.51186,2.53232,2.55503,2.58117,2.61134,2.64615,2.6858,2.72962,2.77564,2.82077,2.86151,2.89507,2.92038,2.93819,2.95021,2.95837,2.96387,2.96754,2.96964,2.97012,2.96892,2.9659,2.961,2.95439,2.94621,2.93656,2.92568,2.91365,2.90054,2.88649,2.87157,2.85599,2.8398,2.82325,2.80637,2.78922,2.77176,2.75396,2.73582,2.7173,2.69838,2.67907,2.65953,2.63997,2.62056,2.60142,2.58261,2.56414,2.54602,2.52828,2.511,2.49429,2.47822,2.46271,2.44769,2.4332:6.4
2.51682,2.51816,2.51946,2.52081,2.52229,2.52386,2.52555,2.52742,2.52948,2.53174,2.5342,2.53684,2.53965,2.54264,2.54581,2.54917,2.55277,2.55667,2.56081,2.56517,2.56972,2.57444,2.57923,2.58401,2.58875,2.59345,2.59806,2.60278,2.60749,2.61228,2.61713,2.62204,2.62704,2.6323,2.63806,2.64474,2.65274,2.66203,2.67261,2.68428,2.69688,2.71017,2.72394,2.73819,2.75304,2.76891,2.78636,2.8066,2.83018,2.85781,2.88973,2.92544,2.96338,3.00088,3.03475,3.06225,3.08218,3.09498,3.10222,3.1055,3.10623,3.10513,3.1026,3.09849,3.09269,3.08513,3.07583,3.06492,3.05254,3.03877,3.02377,3.00762,2.99043,2.97238,2.95357,2.93408,2.91399,2.89355,2.87279,2.85179,2.83056,2.80904,2.78714,2.7649,2.7423,2.71938,2.69628,2.67318,2.65026,2.62766,2.60541,2.58353,2.56208,2.54105,2.52051,2.50057,2.48125,2.46252,2.44439,2.42677:6.8
2.18439,2.18363,2.18281,2.18202,2.1813,2.1807,2.18027,2.17998,2.17983,2.17997,2.18033,2.18091,2.1817,2.18273,2.184,2.18551,2.18734,2.18955,2.1921,2.19491,2.19796,2.20118,2.20445,2.20766,2.21081,2.21399,2.21724,2.22062,2.22423,2.22807,2.23214,2.23644,2.24103,2.24617,2.25218,2.25953,2.26885,2.28014,2.29341,2.30851,2.32525,2.34338,2.36269,2.38312,2.40488,2.4283,2.45402,2.48334,2.51693,2.55554,2.59955,2.64853,2.70088,2.75353,2.80248,2.84417,2.87667,2.90023,2.91667,2.92797,2.93595,2.94161,2.94539,2.94719,2.94696,2.94469,2.94033,2.93386,2.92547,2.91537,2.90373,2.89071,2.87637,2.86097,2.84455,2.82725,2.80925,2.79073,2.77179,2.75249,2.73288,2.7129,2.6925,2.67164,2.65036,2.62868,2.6067,2.58463,2.56272,2.54114,2.52,2.49925,2.4789,2.45895,2.43959,2.42091,2.40297,2.38574,2.36915,2.3532:7.1
2.50203,2.50432,2.50668,2.50898,2.51126,2.51357,2.51599,2.51853,2.52127,2.52408,2.52702,2.53004,2.53321,2.53654,2.53999,2.54362,2.54737,2.55137,2.55555,2.55997,2.56457,2.56925,2.57389,2.57842,2.58289,2.58734,2.59172,2.59607,2.60041,2.6048,2.60925,2.61382,2.61853,2.62351,2.62903,2.63549,2.64341,2.6528,2.66363,2.67575,2.68893,2.70291,2.71754,2.73282,2.74896,2.76644,2.78589,2.8084,2.83457,2.86514,2.90035,2.93959,2.98124,3.02253,3.0602,3.09151,3.11519,3.13183,3.14299,3.1504,3.15522,3.15832,3.15992,3.16,3.15844,3.15513,3.15004,3.14323,3.13487,3.12508,3.11399,3.10168,3.0882,3.07371,3.05828,3.04208,3.02525,3.00788,2.99004,2.97182,2.95326,2.93431,2.91489,2.89498,2.87456,2.85366,2.83242,2.81109,2.78988,2.76888,2.74815,2.72767,2.70745,2.68761,2.66817,2.64924,2.63083,2.61296,2.5956,2.57864:7.3
2.4291,2.4294,2.42976,2.43004,2.43036,2.43077,2.43133,2.43208,2.43303,2.43417,2.43542,2.43689,2.43855,2.44042,2.44251,2.44483,2.44739,2.45026,2.45354,2.45707,2.46077,2.46456,2.46834,2.47205,2.47572,2.47926,2.48286,2.48652,2.4904,2.49449,2.49873,2.50312,2.50773,2.51279,2.51866,2.52578,2.53472,2.54547,2.55795,2.57189,2.58704,2.60313,2.61998,2.63764,2.65641,2.6768,2.69963,2.7262,2.75717,2.7932,2.83454,2.8804,2.92863,2.97596,3.01874,3.05407,3.08084,3.09987,3.113,3.122,3.12836,3.13289,3.13581,3.13709,3.13645,3.13386,3.12936,3.12302,3.115,3.10544,3.09448,3.08229,3.06887,3.05428,3.03878,3.02252,3.00554,2.98807,2.97019,2.95193,2.9333,2.91424,2.89476,2.87479,2.85428,2.83331,2.81203,2.79068,2.76945,2.74849,2.72789,2.70764,2.68773,2.66817,2.64906,2.63058,2.61273,2.59548,2.57871,2.56249:7.9
3.09,3.09225,3.09453,3.09688,3.09937,3.102,3.10473,3.10761,3.11074,3.1142,3.11784,3.12168,3.1257,3.12996,3.13452,3.13937,3.1445,3.15002,3.15595,3.16218,3.16868,3.1753,3.18191,3.18843,3.19481,3.2011,3.20738,3.21375,3.22031,3.22705,3.23392,3.24088,3.24794,3.25528,3.26338,3.27265,3.28367,3.29635,3.31065,3.32625,3.34284,3.36007,3.37773,3.39585,3.4148,3.43519,3.45786,3.48443,3.51545,3.55194,3.59424,3.64167,3.69207,3.74184,3.78673,3.82318,3.84948,3.8664,3.87624,3.8811,3.88259,3.88168,3.87882,3.87401,3.86708,3.85788,3.84643,3.83287,3.81747,3.80043,3.78188,3.76203,3.74093,3.7188,3.69577,3.67199,3.64765,3.62289,3.59793,3.57275,3.54739,3.52168,3.4956,3.46907,3.4421,3.41476,3.38717,3.35959,3.33227,3.30534,3.27887,3.25287,3.22735,3.20233,3.17789,3.15413,3.13105,3.10859,3.08674,3.06546:9.2
3.38922,3.39664,3.40399,3.4113,3.41858,3.42588,3.43325,3.44067,3.44816,3.45586,3.4637,3.47156,3.47952,3.48763,3.49592,3.50443,3.51321,3.52217,3.53144,3.54099,3.55075,3.5606,3.57043,3.58016,3.58972,3.59919,3.60859,3.61796,3.62743,3.63709,3.6469,3.65674,3.66661,3.67669,3.68728,3.69897,3.71219,3.72697,3.74327,3.76068,3.77885,3.79743,3.81616,3.83508,3.85458,3.87527,3.89808,3.9245,3.95524,3.99115,4.03248,4.07853,4.12756,4.17656,4.22181,4.26014,4.28994,4.31172,4.3271,4.33793,4.34572,4.35141,4.35524,4.35707,4.35688,4.35457,4.35027,4.3441,4.33605,4.32624,4.3149,4.30218,4.28825,4.27321,4.25709,4.24012,4.22238,4.20434,4.1858,4.16696,4.1477,4.12807,4.10804,4.08755,4.06649,4.04482,4.02274,4.00052,3.9784,3.9566,3.93521,3.91414,3.89337,3.87291,3.85288,3.83339,3.81432,3.79572,3.77751,3.75961:10.1
2.44674,2.44683,2.44694,2.44709,2.44732,2.44766,2.44818,2.44887,2.44969,2.45081,2.45209,2.45361,2.45537,2.45737,2.45963,2.46221,2.46509,2.46836,2.4719,2.47569,2.4797,2.48376,2.48775,2.49162,2.49532,2.49894,2.50273,2.50677,2.51116,2.51595,2.5211,2.5265,2.53211,2.53813,2.54496,2.55301,2.56287,2.57445,2.5876,2.60204,2.61732,2.63304,2.64899,2.66526,2.68227,2.70081,2.72184,2.74689,2.77661,2.81168,2.85228,2.89764,2.94563,2.99295,3.03583,3.07123,3.0979,3.11653,3.12914,3.13759,3.14327,3.14709,3.14926,3.14976,3.14843,3.14514,3.13993,3.13287,3.12412,3.11384,3.10215,3.0892,3.07511,3.05993,3.04379,3.02681,3.0091,2.99087,2.97226,2.95328,2.93395,2.91419,2.89395,2.8732,2.85189,2.83008,2.80789,2.78554,2.76334,2.74148,2.72002,2.69896,2.67823,2.65789,2.63799,2.61861,2.5998,2.58157,2.56376,2.5464:10.7
3.45278,3.46285,3.47272,3.48244,3.49209,3.5017,3.51128,3.52089,3.53049,3.54013,3.54981,3.55954,3.5693,3.57915,3.58915,3.59927,3.60952,3.61988,3.63045,3.64124,3.6522,3.66323,3.67419,3.68496,3.69556,3.70608,3.71658,3.72711,3.73775,3.74853,3.75946,3.77049,3.78154,3.79266,3.80418,3.81649,3.83008,3.84495,3.86101,3.87794,3.89531,3.91284,3.93043,3.94809,3.96609,3.98501,4.00569,4.02936,4.05667,4.08829,4.12454,4.16489,4.20784,4.25102,4.29146,4.32648,4.35456,4.3758,4.39156,4.4033,4.41206,4.41871,4.4236,4.4268,4.42832,4.42794,4.42558,4.42143,4.41569,4.40847,4.39974,4.38971,4.37863,4.36678,4.35397,4.34035,4.32614,4.31131,4.29624,4.28092,4.26531,4.24938,4.23316,4.21653,4.19934,4.18164,4.16362,4.14549,4.12746,4.10972,4.09232,4.07519,4.05834,4.04174,4.02546,4.00952,3.99395,3.97875,3.96379,3.94896:11.2
2.61809,2.61982,2.62147,2.62313,2.6248,2.62654,2.62843,2.63046,2.63271,2.63515,2.63774,2.64052,2.64352,2.64676,2.65025,2.65403,2.65815,2.66259,2.66738,2.67252,2.67784,2.68316,2.68832,2.69327,2.69808,2.7028,2.70766,2.71279,2.71837,2.72433,2.73063,2.73719,2.74394,2.75094,2.7586,2.76734,2.77777,2.7898,2.80322,2.81769,2.83273,2.84796,2.86315,2.87844,2.89427,2.91152,2.93114,2.95474,2.98297,3.01649,3.05545,3.09915,3.14565,3.1918,3.23396,3.26917,3.29612,3.31542,3.32879,3.33812,3.34477,3.34956,3.35275,3.35426,3.35403,3.35191,3.34791,3.34211,3.33465,3.32573,3.31554,3.30413,3.29156,3.27797,3.26343,3.24815,3.2322,3.21584,3.19911,3.1821,3.16477,3.14708,3.12894,3.1103,3.09111,3.0714,3.05129,3.031,3.01083,2.99102,2.97164,2.95259,2.93384,2.9154,2.89734,2.87968,2.8625,2.84578,2.82941,2.81338:12.5
2.76153,2.76213,2.7628,2.76346,2.76422,2.76512,2.76617,2.7674,2.76882,2.77056,2.77252,2.77478,2.77732,2.78015,2.78333,2.78688,2.79082,2.7952,2.80007,2.80528,2.81074,2.81628,2.82171,2.82695,2.83203,2.83702,2.84224,2.84787,2.85403,2.86083,2.86817,2.87587,2.88384,2.89214,2.90118,2.91152,2.92383,2.93798,2.95368,2.97042,2.98762,3.00475,3.02152,3.03805,3.05496,3.07328,3.09424,3.11972,3.15051,3.18736,3.23047,3.27916,3.33131,3.38344,3.43146,3.47184,3.50285,3.525,3.54018,3.55037,3.55727,3.56196,3.56467,3.56536,3.56399,3.56046,3.55474,3.54693,3.53719,3.52573,3.51274,3.4984,3.48284,3.46619,3.44846,3.42986,3.41053,3.39073,3.37065,3.35027,3.32963,3.30859,3.28707,3.26499,3.24232,3.21907,3.19541,3.1716,3.14798,3.12478,3.1021,3.07993,3.0582,3.03689,3.01599,2.99552,2.97558,2.95612,2.93704,2.91837:14.3
3.34749,3.35503,3.36246,3.36992,3.37733,3.38473,3.39223,3.39981,3.40747,3.4153,3.42323,3.43131,3.43954,3.44798,3.45662,3.46542,3.4744,3.48371,3.49328,3.50316,3.51325,3.52341,3.53349,3.54342,3.55318,3.56283,3.57248,3.58235,3.59259,3.60327,3.61425,3.62535,3.63647,3.64772,3.65945,3.67207,3.68626,3.70188,3.71854,3.7358,3.75304,3.76979,3.78574,3.80091,3.81593,3.83176,3.84979,3.87174,3.89838,3.93043,3.96797,4.01026,4.05538,4.10031,4.14154,4.17609,4.20253,4.22125,4.23392,4.24245,4.24833,4.25235,4.25465,4.25526,4.25404,4.25089,4.24588,4.23913,4.23078,4.22098,4.20989,4.19761,4.18439,4.1702,4.15517,4.13937,4.12304,4.1064,4.08956,4.07249,4.05523,4.03769,4.01977,4.00131,3.98219,3.96259,3.94262,3.92245,3.90239,3.88264,3.86336,3.84447,3.82581,3.80741,3.78926,3.77143,3.75382,3.7364,3.71913,3.70207:16.0
3.86543,3.87217,3.87899,3.88595,3.89309,3.90047,3.90805,3.91575,3.92366,3.93195,3.94064,3.94957,3.9587,3.96805,3.97773,3.98786,3.99844,4.00936,4.02065,4.03238,4.04441,4.05661,4.06886,4.081,4.09296,4.10488,4.1168,4.12904,4.1417,4.15476,4.16811,4.18159,4.195,4.20827,4.22183,4.23607,4.25172,4.2685,4.28633,4.30451,4.32225,4.33905,4.35464,4.36909,4.38306,4.39755,4.41426,4.43485,4.46015,4.49106,4.52807,4.57026,4.61538,4.66003,4.70025,4.73279,4.75613,4.7707,4.77813,4.78081,4.78058,4.7779,4.77333,4.76669,4.75798,4.7472,4.73417,4.71906,4.70219,4.68367,4.66366,4.64241,4.61988,4.5961,4.57132,4.54599,4.52021,4.49376,4.46722,4.44044,4.41347,4.38621,4.35852,4.33036,4.30158,4.27217,4.24226,4.21219,4.1824,4.15317,4.12448,4.09623,4.06837,4.04096,4.01399,3.98755,3.96163,3.93614,3.91103,3.88612:17.0
2.4571,2.45753,2.458,2.45851,2.45914,2.45993,2.46092,2.46218,2.4637,2.46556,2.46773,2.47015,2.47292,2.47609,2.47969,2.48381,2.48834,2.49349,2.49913,2.50529,2.51177,2.51831,2.52462,2.53054,2.53614,2.54174,2.54766,2.55419,2.56157,2.56979,2.57867,2.58797,2.59743,2.60706,2.61732,2.62876,2.64214,2.6574,2.67399,2.6912,2.7082,2.72422,2.73887,2.75242,2.76577,2.78041,2.79803,2.82075,2.8494,2.88464,2.92668,2.97457,3.02604,3.0775,3.12474,3.16434,3.19473,3.21655,3.23181,3.24257,3.25032,3.25612,3.26017,3.26243,3.26276,3.26105,3.2573,3.25163,3.24417,3.23516,3.22476,3.2131,3.2002,3.18622,3.17128,3.15548,3.13896,3.12201,3.10479,3.08731,3.06956,3.05141,3.03278,3.01352,2.99348,2.97264,2.95113,2.92931,2.90764,2.88643,2.86575,2.84549,2.82557,2.80593,2.78655,2.76754,2.74893,2.73054,2.71234,2.6943:18.1
2.88306,2.88677,2.89044,2.89414,2.89791,2.90176,2.90573,2.90989,2.9143,2.91903,2.92394,2.92904,2.93437,2.94003,2.94609,2.95257,2.95938,2.96665,2.97443,2.98265,2.99116,2.99972,3.00809,3.01613,3.02389,3.03147,3.03931,3.0477,3.05682,3.06678,3.07739,3.08834,3.09939,3.11056,3.12223,3.13496,3.14937,3.16535,3.18243,3.1999,3.21697,3.23295,3.24754,3.26104,3.27428,3.28862,3.30558,3.32734,3.35473,3.38852,3.42889,3.47512,3.52502,3.57505,3.62108,3.65958,3.68876,3.70925,3.72293,3.73192,3.73779,3.74156,3.74356,3.74368,3.74189,3.73809,3.73223,3.72441,3.71482,3.70372,3.69125,3.67759,3.6629,3.64718,3.63051,3.61314,3.59514,3.57685,3.55838,3.53986,3.52109,3.50195,3.48234,3.46223,3.44151,3.42011,3.39813,3.3759,3.35383,3.33214,3.311,3.29039,3.2701,3.25002,3.23018,3.21065,3.19142,3.17242,3.15349,3.1347:19.4
3.29881,3.30738,3.31586,3.32423,3.33257,3.34094,3.34939,3.35796,3.36666,3.37546,3.38441,3.39341,3.40255,3.41191,3.4215,3.43138,3.44156,3.45203,3.46293,3.47418,3.48569,3.49729,3.50876,3.51993,3.53083,3.54155,3.55232,3.56349,3.57531,3.58782,3.60084,3.61404,3.6271,3.63998,3.65304,3.66685,3.68195,3.69809,3.71473,3.73111,3.74636,3.75971,3.77075,3.77971,3.7876,3.79579,3.80605,3.82038,3.83956,3.86416,3.8941,3.92865,3.96614,4.00387,4.03878,4.06834,4.0913,4.108,4.11974,4.12825,4.13442,4.1389,4.1419,4.14347,4.14354,4.14196,4.13884,4.13427,4.12834,4.1212,4.11295,4.10376,4.09368,4.08281,4.07122,4.05897,4.0463,4.03331,4.02036,4.00725,3.99401,3.98042,3.96649,3.95204,3.93691,3.921,3.90441,3.88754,3.87076,3.85427,3.8382,3.82241,3.80682,3.79124,3.77567,3.7601,3.74453,3.72884,3.71288,3.69671:24.8
2.70628,2.70826,2.71029,2.7124,2.71465,2.71706,2.71968,2.7226,2.72576,2.72931,2.73311,2.73725,2.74177,2.74672,2.75211,2.75797,2.76431,2.77121,2.77869,2.78675,2.79528,2.80399,2.81261,2.82096,2.82907,2.83711,2.84537,2.85443,2.86451,2.87581,2.88813,2.90097,2.91383,2.9266,2.93965,2.95375,2.96952,2.98665,3.0044,3.02172,3.03738,3.05037,3.06017,3.06705,3.07218,3.07748,3.08516,3.09784,3.11655,3.14198,3.17415,3.21218,3.25394,3.29617,3.33508,3.3674,3.39158,3.40791,3.41812,3.42408,3.42725,3.42859,3.42833,3.4264,3.42278,3.41737,3.41016,3.40127,3.3909,3.37923,3.36642,3.35262,3.33794,3.32251,3.30636,3.28961,3.27242,3.25499,3.23759,3.22027,3.2029,3.18537,3.1675,3.14911,3.13001,3.11008,3.08947,3.06859,3.04795,3.02791,3.00854,2.98973,2.97128,2.95307,2.93505,2.91717,2.89927,2.88124,2.86292,2.84446:27.2
2.66118,2.66172,2.66232,2.66297,2.66379,2.66482,2.66612,2.66783,2.66992,2.67245,2.6754,2.67887,2.68287,2.68748,2.69285,2.699,2.70596,2.71377,2.7224,2.73172,2.74133,2.7508,2.75974,2.76798,2.77569,2.78335,2.79168,2.8015,2.81312,2.82666,2.8417,2.85757,2.87361,2.88955,2.90581,2.92322,2.94266,2.96368,2.98534,3.00628,3.02501,3.04033,3.05169,3.05963,3.06587,3.0729,3.08344,3.10045,3.12506,3.15795,3.19915,3.24763,3.30094,3.35529,3.40621,3.44979,3.48393,3.50877,3.52604,3.53787,3.54612,3.552,3.55575,3.55741,3.55684,3.55402,3.54897,3.54179,3.53276,3.52211,3.51003,3.49665,3.48213,3.46661,3.45017,3.43291,3.41501,3.39675,3.37846,3.36014,3.34179,3.3232,3.30417,3.2845,3.26391,3.2423,3.21985,3.19706,3.17455,3.1528,3.13189,3.11167,3.09195,3.07253,3.05325,3.03411,3.01496,2.99568,2.97606,2.95627:28.4
2.4916,2.49183,2.49209,2.49243,2.49296,2.49373,2.4948,2.49621,2.498,2.50019,2.50281,2.50585,2.50937,2.51343,2.51811,2.52347,2.52952,2.53624,2.54376,2.55204,2.5609,2.56985,2.57845,2.58651,2.59404,2.6012,2.60856,2.61684,2.62663,2.63816,2.65126,2.66526,2.67947,2.69353,2.70763,2.72247,2.73873,2.75684,2.77591,2.79484,2.81217,2.82651,2.83701,2.84369,2.84777,2.85143,2.85721,2.8674,2.88453,2.90922,2.94176,2.98159,3.02678,3.07393,3.11882,3.15761,3.18803,3.20995,3.22481,3.23456,3.24101,3.24511,3.24748,3.2482,3.24712,3.24408,3.2391,3.23231,3.22388,3.21398,3.20279,3.19048,3.17721,3.16304,3.14806,3.13227,3.11587,3.09905,3.0821,3.06518,3.04825,3.03118,3.0138,2.99589,2.97714,2.95731,2.93645,2.915,2.89362,2.87283,2.85283,2.8335,2.81459,2.79591,2.77743,2.75912,2.74081,2.72225,2.70332,2.6841:29.2
3.14626,3.15166,3.15703,3.16244,3.16791,3.17348,3.17923,3.18521,3.1914,3.19792,3.20466,3.21167,3.21896,3.22665,3.23481,3.24345,3.25255,3.26199,3.27205,3.28263,3.29378,3.30525,3.31673,3.32801,3.33896,3.34976,3.36068,3.37238,3.38527,3.39963,3.4152,3.43129,3.44727,3.46298,3.47899,3.49632,3.51585,3.5372,3.55932,3.58079,3.59985,3.61481,3.62461,3.62933,3.63054,3.63101,3.63398,3.64281,3.65859,3.68207,3.71307,3.75049,3.792,3.83423,3.87342,3.90643,3.93181,3.95001,3.96265,3.97146,3.9777,3.98224,3.98529,3.98674,3.9865,3.98449,3.98077,3.97541,3.96853,3.96031,3.95092,3.94047,3.92904,3.91669,3.9035,3.88954,3.87495,3.86015,3.84524,3.83036,3.81533,3.80008,3.7844,3.76797,3.75045,3.73165,3.71175,3.69136,3.67117,3.65168,3.63298,3.61483,3.59695,3.57915,3.56142,3.54365,3.52563,3.50705,3.48765,3.46769:31.3
2.57992,2.5804,2.58099,2.58175,2.58266,2.58381,2.5853,2.58719,2.58949,2.59225,2.59546,2.59916,2.60344,2.60844,2.61426,2.6209,2.6283,2.6366,2.64579,2.65571,2.66593,2.67596,2.68532,2.69384,2.70178,2.70963,2.71821,2.72828,2.74035,2.75449,2.77031,2.78703,2.8038,2.82023,2.83676,2.85417,2.87346,2.8941,2.91494,2.93442,2.95082,2.96273,2.96953,2.97185,2.97162,2.97162,2.97492,2.98472,3.00209,3.02779,3.06168,3.10263,3.14821,3.19467,3.23772,3.27377,3.30103,3.31999,3.33247,3.34044,3.34554,3.34879,3.35034,3.35024,3.34828,3.34443,3.33876,3.3314,3.32251,3.31228,3.30093,3.28863,3.27554,3.2617,3.24715,3.23194,3.21627,3.20037,3.18462,3.1691,3.15364,3.13802,3.122,3.10534,3.08777,3.06908,3.04942,3.02933,3.00947,2.99033,2.97211,2.95464,2.93756,2.92062,2.90367,2.88668,2.86951,2.8518,2.83347,2.81473:33.8
2.56875,2.56923,2.56985,2.5706,2.5715,2.57268,2.5742,2.5761,2.57841,2.58129,2.58459,2.58841,2.59283,2.59793,2.60381,2.61049,2.61803,2.62646,2.6358,2.64594,2.65656,2.66712,2.67713,2.68634,2.69486,2.70325,2.7124,2.72326,2.73624,2.75153,2.76861,2.78661,2.80469,2.82242,2.84016,2.8588,2.87925,2.901,2.92268,2.94262,2.9589,2.96995,2.97513,2.97519,2.97228,2.96949,2.97017,2.97767,2.99317,3.01732,3.04997,3.08988,3.13449,3.18006,3.22227,3.25753,3.28414,3.30259,3.31466,3.32223,3.32701,3.32995,3.33129,3.331,3.32899,3.32509,3.31935,3.31195,3.30309,3.29304,3.28196,3.26999,3.2572,3.24373,3.22963,3.21494,3.19986,3.18464,3.16959,3.15474,3.14004,3.12525,3.11007,3.0942,3.07733,3.05928,3.0402,3.02069,3.00145,2.98301,2.96551,2.9487,2.93226,2.91592,2.89952,2.88291,2.86595,2.84836,2.82998,2.81111:35.5
2.65884,2.65943,2.66023,2.66108,2.66215,2.6636,2.6655,2.66787,2.6707,2.67405,2.67793,2.68247,2.68779,2.69399,2.70113,2.70924,2.71836,2.72863,2.73998,2.75222,2.76488,2.7773,2.78888,2.79945,2.80927,2.81894,2.82961,2.84233,2.8578,2.87611,2.89671,2.91843,2.94011,2.96121,2.98209,3.00378,3.02727,3.05186,3.07592,3.09723,3.11338,3.12235,3.12336,3.11738,3.10714,3.09663,3.08976,3.09058,3.10028,3.11944,3.14776,3.18386,3.22511,3.26766,3.30724,3.34036,3.36529,3.38239,3.39337,3.40012,3.4042,3.40646,3.4072,3.4064,3.40391,3.39969,3.39374,3.38624,3.37745,3.36758,3.35682,3.34528,3.33315,3.32046,3.30723,3.29347,3.27941,3.26533,3.25161,3.23831,3.22525,3.21218,3.19873,3.18455,3.16919,3.15241,3.13437,3.11574,3.09745,3.08013,3.0639,3.04851,3.03351,3.01851,3.00327,2.98759,2.97121,2.95374,2.93514,2.91564:42.5
