/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.logdispatcher;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.consensus.config.IoTConsensusConfig;
import org.apache.iotdb.consensus.iot.logdispatcher.LogDispatcher;
import org.apache.iotdb.consensus.iot.thrift.TLogEntry;

public class Batch {
    private final IoTConsensusConfig config;
    private long startIndex;
    private long endIndex;
    private final List<TLogEntry> logEntries = new ArrayList<TLogEntry>();
    private long logEntriesNumFromWAL = 0L;
    private long memorySize;
    private boolean synced;

    public Batch(IoTConsensusConfig config) {
        this.config = config;
    }

    public void buildIndex() {
        if (!this.logEntries.isEmpty()) {
            this.startIndex = this.logEntries.get(0).getSearchIndex();
            this.endIndex = this.logEntries.get(this.logEntries.size() - 1).getSearchIndex();
        }
    }

    public void addTLogEntry(TLogEntry entry) {
        this.logEntries.add(entry);
        if (entry.fromWAL) {
            ++this.logEntriesNumFromWAL;
        }
        this.memorySize += entry.getMemorySize();
    }

    public boolean canAccumulate() {
        long receiverMemSize = LogDispatcher.getReceiverMemSizeSum().get();
        long senderMemSize = LogDispatcher.getSenderMemSizeSum().get();
        double multiplier = senderMemSize > 0L ? (double)receiverMemSize / (double)senderMemSize : 1.0;
        multiplier = Math.max(multiplier, 1.0);
        return this.logEntries.size() < this.config.getReplication().getMaxLogEntriesNumPerBatch() && (long)((double)this.memorySize * multiplier) < (long)this.config.getReplication().getMaxSizePerBatch();
    }

    public long getStartIndex() {
        return this.startIndex;
    }

    public long getEndIndex() {
        return this.endIndex;
    }

    public List<TLogEntry> getLogEntries() {
        return this.logEntries;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public void setSynced(boolean synced) {
        this.synced = synced;
    }

    public boolean isEmpty() {
        return this.logEntries.isEmpty();
    }

    public long getMemorySize() {
        return this.memorySize;
    }

    public long getLogEntriesNumFromWAL() {
        return this.logEntriesNumFromWAL;
    }

    public String toString() {
        return "Batch{startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + ", size=" + this.logEntries.size() + ", memorySize=" + this.memorySize + '}';
    }
}

