/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.observation.impl;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.observation.MetricConfig;
import org.apache.hc.client5.http.observation.ObservingOptions;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

public final class MeteredTlsStrategy
implements TlsStrategy {
    private final TlsStrategy delegate;
    private final MeterRegistry registry;
    private final MetricConfig mc;
    private final ObservingOptions opts;

    public MeteredTlsStrategy(TlsStrategy delegate, MeterRegistry registry, MetricConfig mc, ObservingOptions opts) {
        this.delegate = (TlsStrategy)Args.notNull((Object)delegate, (String)"delegate");
        this.registry = (MeterRegistry)Args.notNull((Object)registry, (String)"registry");
        this.mc = mc != null ? mc : MetricConfig.builder().build();
        this.opts = opts != null ? opts : ObservingOptions.DEFAULT;
    }

    @Deprecated
    public MeteredTlsStrategy(TlsStrategy delegate, MeterRegistry registry, String prefix) {
        this(delegate, registry, MetricConfig.builder().prefix(prefix != null ? prefix : "hc").build(), ObservingOptions.DEFAULT);
    }

    private List<Tag> tags(String result, String sniOrNull) {
        ArrayList<Tag> ts = new ArrayList<Tag>(2);
        ts.add(Tag.of((String)"result", (String)result));
        if (this.opts.tagLevel == ObservingOptions.TagLevel.EXTENDED && sniOrNull != null) {
            ts.add(Tag.of((String)"sni", (String)sniOrNull));
        }
        if (!this.mc.commonTags.isEmpty()) {
            ts.addAll(this.mc.commonTags);
        }
        return ts;
    }

    public void upgrade(TransportSecurityLayer sessionLayer, NamedEndpoint endpoint, Object attachment, Timeout handshakeTimeout, final FutureCallback<TransportSecurityLayer> callback) {
        final long t0 = System.nanoTime();
        final String sni = endpoint != null ? endpoint.getHostName() : null;
        this.delegate.upgrade(sessionLayer, endpoint, attachment, handshakeTimeout, (FutureCallback)new FutureCallback<TransportSecurityLayer>(){

            public void completed(TransportSecurityLayer result) {
                List t = MeteredTlsStrategy.this.tags("ok", sni);
                Timer.builder((String)(((MeteredTlsStrategy)MeteredTlsStrategy.this).mc.prefix + ".tls.handshake")).tags((Iterable)t).register(MeteredTlsStrategy.this.registry).record(System.nanoTime() - t0, TimeUnit.NANOSECONDS);
                Counter.builder((String)(((MeteredTlsStrategy)MeteredTlsStrategy.this).mc.prefix + ".tls.handshakes")).tags((Iterable)t).register(MeteredTlsStrategy.this.registry).increment();
                if (callback != null) {
                    callback.completed((Object)result);
                }
            }

            public void failed(Exception ex) {
                List t = MeteredTlsStrategy.this.tags("error", sni);
                Timer.builder((String)(((MeteredTlsStrategy)MeteredTlsStrategy.this).mc.prefix + ".tls.handshake")).tags((Iterable)t).register(MeteredTlsStrategy.this.registry).record(System.nanoTime() - t0, TimeUnit.NANOSECONDS);
                Counter.builder((String)(((MeteredTlsStrategy)MeteredTlsStrategy.this).mc.prefix + ".tls.handshakes")).tags((Iterable)t).register(MeteredTlsStrategy.this.registry).increment();
                if (callback != null) {
                    callback.failed(ex);
                }
            }

            public void cancelled() {
                List t = MeteredTlsStrategy.this.tags("cancel", sni);
                Timer.builder((String)(((MeteredTlsStrategy)MeteredTlsStrategy.this).mc.prefix + ".tls.handshake")).tags((Iterable)t).register(MeteredTlsStrategy.this.registry).record(System.nanoTime() - t0, TimeUnit.NANOSECONDS);
                Counter.builder((String)(((MeteredTlsStrategy)MeteredTlsStrategy.this).mc.prefix + ".tls.handshakes")).tags((Iterable)t).register(MeteredTlsStrategy.this.registry).increment();
                if (callback != null) {
                    callback.cancelled();
                }
            }
        });
    }

    @Deprecated
    public boolean upgrade(TransportSecurityLayer sessionLayer, HttpHost host, SocketAddress localAddress, SocketAddress remoteAddress, Object attachment, Timeout handshakeTimeout) {
        long t0 = System.nanoTime();
        String sni = host != null ? host.getHostName() : null;
        try {
            boolean upgraded = this.delegate.upgrade(sessionLayer, host, localAddress, remoteAddress, attachment, handshakeTimeout);
            List<Tag> t = this.tags("ok", sni);
            Timer.builder((String)(this.mc.prefix + ".tls.handshake")).tags(t).register(this.registry).record(System.nanoTime() - t0, TimeUnit.NANOSECONDS);
            Counter.builder((String)(this.mc.prefix + ".tls.handshakes")).tags(t).register(this.registry).increment();
            return upgraded;
        }
        catch (RuntimeException ex) {
            List<Tag> t = this.tags("error", sni);
            Timer.builder((String)(this.mc.prefix + ".tls.handshake")).tags(t).register(this.registry).record(System.nanoTime() - t0, TimeUnit.NANOSECONDS);
            Counter.builder((String)(this.mc.prefix + ".tls.handshakes")).tags(t).register(this.registry).increment();
            throw ex;
        }
    }
}

