/*
 * Decompiled with CFR 0.152.
 */
package io.github.ollama4j;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.ollama4j.exceptions.OllamaBaseException;
import io.github.ollama4j.exceptions.RoleNotFoundException;
import io.github.ollama4j.exceptions.ToolInvocationException;
import io.github.ollama4j.exceptions.ToolNotFoundException;
import io.github.ollama4j.models.chat.OllamaChatMessage;
import io.github.ollama4j.models.chat.OllamaChatMessageRole;
import io.github.ollama4j.models.chat.OllamaChatRequest;
import io.github.ollama4j.models.chat.OllamaChatRequestBuilder;
import io.github.ollama4j.models.chat.OllamaChatResult;
import io.github.ollama4j.models.chat.OllamaChatStreamObserver;
import io.github.ollama4j.models.chat.OllamaChatToolCalls;
import io.github.ollama4j.models.embeddings.OllamaEmbedRequestModel;
import io.github.ollama4j.models.embeddings.OllamaEmbedResponseModel;
import io.github.ollama4j.models.embeddings.OllamaEmbeddingResponseModel;
import io.github.ollama4j.models.embeddings.OllamaEmbeddingsRequestModel;
import io.github.ollama4j.models.generate.OllamaGenerateRequest;
import io.github.ollama4j.models.generate.OllamaStreamHandler;
import io.github.ollama4j.models.generate.OllamaTokenHandler;
import io.github.ollama4j.models.ps.ModelsProcessResponse;
import io.github.ollama4j.models.request.Auth;
import io.github.ollama4j.models.request.BasicAuth;
import io.github.ollama4j.models.request.BearerAuth;
import io.github.ollama4j.models.request.CustomModelFileContentsRequest;
import io.github.ollama4j.models.request.CustomModelFilePathRequest;
import io.github.ollama4j.models.request.CustomModelRequest;
import io.github.ollama4j.models.request.ModelRequest;
import io.github.ollama4j.models.request.OllamaChatEndpointCaller;
import io.github.ollama4j.models.request.OllamaGenerateEndpointCaller;
import io.github.ollama4j.models.response.LibraryModel;
import io.github.ollama4j.models.response.LibraryModelDetail;
import io.github.ollama4j.models.response.LibraryModelTag;
import io.github.ollama4j.models.response.ListModelsResponse;
import io.github.ollama4j.models.response.Model;
import io.github.ollama4j.models.response.ModelDetail;
import io.github.ollama4j.models.response.ModelPullResponse;
import io.github.ollama4j.models.response.OllamaAsyncResultStreamer;
import io.github.ollama4j.models.response.OllamaResult;
import io.github.ollama4j.models.response.OllamaStructuredResult;
import io.github.ollama4j.models.response.OllamaVersion;
import io.github.ollama4j.tools.OllamaToolsResult;
import io.github.ollama4j.tools.ReflectionalToolFunction;
import io.github.ollama4j.tools.ToolFunction;
import io.github.ollama4j.tools.ToolFunctionCallSpec;
import io.github.ollama4j.tools.ToolRegistry;
import io.github.ollama4j.tools.Tools;
import io.github.ollama4j.tools.annotations.OllamaToolService;
import io.github.ollama4j.tools.annotations.ToolProperty;
import io.github.ollama4j.tools.annotations.ToolSpec;
import io.github.ollama4j.utils.Options;
import io.github.ollama4j.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OllamaAPI {
    private static final Logger logger = LoggerFactory.getLogger(OllamaAPI.class);
    private final String host;
    private Auth auth;
    private final ToolRegistry toolRegistry = new ToolRegistry();
    private long requestTimeoutSeconds = 10L;
    private boolean verbose = true;
    private int maxChatToolCallRetries = 3;
    private int numberOfRetriesForModelPull = 0;

    public OllamaAPI() {
        this.host = "http://localhost:11434";
    }

    public OllamaAPI(String host) {
        this.host = host.endsWith("/") ? host.substring(0, host.length() - 1) : host;
        if (this.verbose) {
            logger.info("Ollama API initialized with host: {}", (Object)this.host);
        }
    }

    public void setBasicAuth(String username, String password) {
        this.auth = new BasicAuth(username, password);
    }

    public void setBearerAuth(String bearerToken) {
        this.auth = new BearerAuth(bearerToken);
    }

    public boolean ping() {
        HttpResponse<String> response;
        HttpRequest httpRequest;
        String url = this.host + "/api/tags";
        HttpClient httpClient = HttpClient.newHttpClient();
        try {
            httpRequest = this.getRequestBuilderDefault(new URI(url)).header("Accept", "application/json").header("Content-Type", "application/json").GET().build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        try {
            response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        }
        catch (HttpConnectTimeoutException e) {
            return false;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        int statusCode = response.statusCode();
        return statusCode == 200;
    }

    public ModelsProcessResponse ps() throws IOException, InterruptedException, OllamaBaseException {
        String url = this.host + "/api/ps";
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest httpRequest = null;
        try {
            httpRequest = this.getRequestBuilderDefault(new URI(url)).header("Accept", "application/json").header("Content-Type", "application/json").GET().build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HttpResponse<String> response = null;
        response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        String responseString = response.body();
        if (statusCode == 200) {
            return Utils.getObjectMapper().readValue(responseString, ModelsProcessResponse.class);
        }
        throw new OllamaBaseException(statusCode + " - " + responseString);
    }

    public List<Model> listModels() throws OllamaBaseException, IOException, InterruptedException, URISyntaxException {
        String url = this.host + "/api/tags";
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest httpRequest = this.getRequestBuilderDefault(new URI(url)).header("Accept", "application/json").header("Content-Type", "application/json").GET().build();
        HttpResponse<String> response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        String responseString = response.body();
        if (statusCode == 200) {
            return Utils.getObjectMapper().readValue(responseString, ListModelsResponse.class).getModels();
        }
        throw new OllamaBaseException(statusCode + " - " + responseString);
    }

    public List<LibraryModel> listModelsFromLibrary() throws OllamaBaseException, IOException, InterruptedException, URISyntaxException {
        String url = "https://ollama.com/library";
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest httpRequest = this.getRequestBuilderDefault(new URI(url)).header("Accept", "application/json").header("Content-Type", "application/json").GET().build();
        HttpResponse<String> response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        String responseString = response.body();
        ArrayList<LibraryModel> models = new ArrayList<LibraryModel>();
        if (statusCode == 200) {
            Document doc = Jsoup.parse(responseString);
            Elements modelSections = doc.selectXpath("//*[@id='repo']/ul/li/a");
            for (Element e : modelSections) {
                LibraryModel model = new LibraryModel();
                Elements names = e.select("div > h2 > div > span");
                Elements desc = e.select("div > p");
                Elements pullCounts = e.select("div:nth-of-type(2) > p > span:first-of-type > span:first-of-type");
                Elements popularTags = e.select("div > div > span");
                Elements totalTags = e.select("div:nth-of-type(2) > p > span:nth-of-type(2) > span:first-of-type");
                Elements lastUpdatedTime = e.select("div:nth-of-type(2) > p > span:nth-of-type(3) > span:nth-of-type(2)");
                if (names.first() == null || names.isEmpty()) continue;
                Optional.ofNullable(names.first()).map(Element::text).ifPresent(model::setName);
                model.setDescription(Optional.ofNullable(desc.first()).map(Element::text).orElse(""));
                model.setPopularTags(Optional.of(popularTags).map(tags -> tags.stream().map(Element::text).collect(Collectors.toList())).orElse(new ArrayList()));
                model.setPullCount(Optional.ofNullable(pullCounts.first()).map(Element::text).orElse(""));
                model.setTotalTags(Optional.ofNullable(totalTags.first()).map(Element::text).map(Integer::parseInt).orElse(0));
                model.setLastUpdated(Optional.ofNullable(lastUpdatedTime.first()).map(Element::text).orElse(""));
                models.add(model);
            }
            return models;
        }
        throw new OllamaBaseException(statusCode + " - " + responseString);
    }

    public LibraryModelDetail getLibraryModelDetails(LibraryModel libraryModel) throws OllamaBaseException, IOException, InterruptedException, URISyntaxException {
        String url = String.format("https://ollama.com/library/%s/tags", libraryModel.getName());
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest httpRequest = this.getRequestBuilderDefault(new URI(url)).header("Accept", "application/json").header("Content-Type", "application/json").GET().build();
        HttpResponse<String> response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        String responseString = response.body();
        ArrayList<LibraryModelTag> libraryModelTags = new ArrayList<LibraryModelTag>();
        if (statusCode == 200) {
            Document doc = Jsoup.parse(responseString);
            Elements tagSections = doc.select("html > body > main > div > section > div > div > div:nth-child(n+2) > div");
            for (Element e : tagSections) {
                Elements tags = e.select("div > a > div");
                Elements tagsMetas = e.select("div > span");
                LibraryModelTag libraryModelTag = new LibraryModelTag();
                if (tags.first() == null || tags.isEmpty()) continue;
                libraryModelTag.setName(libraryModel.getName());
                Optional.ofNullable(tags.first()).map(Element::text).ifPresent(libraryModelTag::setTag);
                libraryModelTag.setSize(Optional.ofNullable(tagsMetas.first()).map(element -> element.text().split("\u2022")).filter(parts -> ((String[])parts).length > 1).map(parts -> parts[1].trim()).orElse(""));
                libraryModelTag.setLastUpdated(Optional.ofNullable(tagsMetas.first()).map(element -> element.text().split("\u2022")).filter(parts -> ((String[])parts).length > 1).map(parts -> parts[2].trim()).orElse(""));
                libraryModelTags.add(libraryModelTag);
            }
            LibraryModelDetail libraryModelDetail = new LibraryModelDetail();
            libraryModelDetail.setModel(libraryModel);
            libraryModelDetail.setTags(libraryModelTags);
            return libraryModelDetail;
        }
        throw new OllamaBaseException(statusCode + " - " + responseString);
    }

    @Deprecated
    public LibraryModelTag findModelTagFromLibrary(String modelName, String tag) throws OllamaBaseException, IOException, URISyntaxException, InterruptedException {
        List<LibraryModel> libraryModels = this.listModelsFromLibrary();
        LibraryModel libraryModel = libraryModels.stream().filter(model -> model.getName().equals(modelName)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("Model by name '%s' not found", modelName)));
        LibraryModelDetail libraryModelDetail = this.getLibraryModelDetails(libraryModel);
        return libraryModelDetail.getTags().stream().filter(tagName -> tagName.getTag().equals(tag)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("Tag '%s' for model '%s' not found", tag, modelName)));
    }

    public void pullModel(String modelName) throws OllamaBaseException, IOException, URISyntaxException, InterruptedException {
        if (this.numberOfRetriesForModelPull == 0) {
            this.doPullModel(modelName);
            return;
        }
        long baseDelayMillis = 3000L;
        for (int numberOfRetries = 0; numberOfRetries < this.numberOfRetriesForModelPull; ++numberOfRetries) {
            try {
                this.doPullModel(modelName);
                return;
            }
            catch (OllamaBaseException e) {
                this.handlePullRetry(modelName, numberOfRetries, this.numberOfRetriesForModelPull, baseDelayMillis);
                continue;
            }
        }
        throw new OllamaBaseException("Failed to pull model " + modelName + " after " + this.numberOfRetriesForModelPull + " retries");
    }

    private void handlePullRetry(String modelName, int currentRetry, int maxRetries, long baseDelayMillis) throws InterruptedException {
        int attempt = currentRetry + 1;
        if (attempt < maxRetries) {
            long backoffMillis = baseDelayMillis * (1L << currentRetry);
            logger.error("Failed to pull model {}, retrying in {}s... (attempt {}/{})", modelName, backoffMillis / 1000L, attempt, maxRetries);
            try {
                Thread.sleep(backoffMillis);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw ie;
            }
        } else {
            logger.error("Failed to pull model {} after {} attempts, no more retries.", (Object)modelName, (Object)maxRetries);
        }
    }

    private void doPullModel(String modelName) throws OllamaBaseException, IOException, URISyntaxException, InterruptedException {
        String url = this.host + "/api/pull";
        String jsonData = new ModelRequest(modelName).toString();
        HttpRequest request = this.getRequestBuilderDefault(new URI(url)).POST(HttpRequest.BodyPublishers.ofString(jsonData)).header("Accept", "application/json").header("Content-Type", "application/json").build();
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
        int statusCode = response.statusCode();
        InputStream responseBodyStream = response.body();
        String responseString = "";
        boolean success = false;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(responseBodyStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                ModelPullResponse modelPullResponse = Utils.getObjectMapper().readValue(line, ModelPullResponse.class);
                if (modelPullResponse != null) {
                    if (modelPullResponse.getError() != null && !modelPullResponse.getError().trim().isEmpty()) {
                        throw new OllamaBaseException("Model pull failed: " + modelPullResponse.getError());
                    }
                    if (modelPullResponse.getStatus() == null) continue;
                    if (this.verbose) {
                        logger.info("{}: {}", (Object)modelName, (Object)modelPullResponse.getStatus());
                    }
                    if (!"success".equalsIgnoreCase(modelPullResponse.getStatus())) continue;
                    success = true;
                    continue;
                }
                logger.error("Received null response for model pull.");
            }
        }
        if (!success) {
            logger.error("Model pull failed or returned invalid status.");
            throw new OllamaBaseException("Model pull failed or returned invalid status.");
        }
        if (statusCode != 200) {
            throw new OllamaBaseException(statusCode + " - " + responseString);
        }
    }

    public String getVersion() throws URISyntaxException, IOException, InterruptedException, OllamaBaseException {
        String url = this.host + "/api/version";
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest httpRequest = this.getRequestBuilderDefault(new URI(url)).header("Accept", "application/json").header("Content-Type", "application/json").GET().build();
        HttpResponse<String> response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        String responseString = response.body();
        if (statusCode == 200) {
            return Utils.getObjectMapper().readValue(responseString, OllamaVersion.class).getVersion();
        }
        throw new OllamaBaseException(statusCode + " - " + responseString);
    }

    public void pullModel(LibraryModelTag libraryModelTag) throws OllamaBaseException, IOException, URISyntaxException, InterruptedException {
        String tagToPull = String.format("%s:%s", libraryModelTag.getName(), libraryModelTag.getTag());
        this.pullModel(tagToPull);
    }

    public ModelDetail getModelDetails(String modelName) throws IOException, OllamaBaseException, InterruptedException, URISyntaxException {
        String url = this.host + "/api/show";
        String jsonData = new ModelRequest(modelName).toString();
        HttpRequest request = this.getRequestBuilderDefault(new URI(url)).header("Accept", "application/json").header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonData)).build();
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        String responseBody = response.body();
        if (statusCode == 200) {
            return Utils.getObjectMapper().readValue(responseBody, ModelDetail.class);
        }
        throw new OllamaBaseException(statusCode + " - " + responseBody);
    }

    @Deprecated
    public void createModelWithFilePath(String modelName, String modelFilePath) throws IOException, InterruptedException, OllamaBaseException, URISyntaxException {
        String url = this.host + "/api/create";
        String jsonData = new CustomModelFilePathRequest(modelName, modelFilePath).toString();
        HttpRequest request = this.getRequestBuilderDefault(new URI(url)).header("Accept", "application/json").header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonData, StandardCharsets.UTF_8)).build();
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        String responseString = response.body();
        if (statusCode != 200) {
            throw new OllamaBaseException(statusCode + " - " + responseString);
        }
        if (responseString.contains("error")) {
            throw new OllamaBaseException(responseString);
        }
        if (this.verbose) {
            logger.info(responseString);
        }
    }

    @Deprecated
    public void createModelWithModelFileContents(String modelName, String modelFileContents) throws IOException, InterruptedException, OllamaBaseException, URISyntaxException {
        String url = this.host + "/api/create";
        String jsonData = new CustomModelFileContentsRequest(modelName, modelFileContents).toString();
        HttpRequest request = this.getRequestBuilderDefault(new URI(url)).header("Accept", "application/json").header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonData, StandardCharsets.UTF_8)).build();
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        String responseString = response.body();
        if (statusCode != 200) {
            throw new OllamaBaseException(statusCode + " - " + responseString);
        }
        if (responseString.contains("error")) {
            throw new OllamaBaseException(responseString);
        }
        if (this.verbose) {
            logger.info(responseString);
        }
    }

    public void createModel(CustomModelRequest customModelRequest) throws IOException, InterruptedException, OllamaBaseException, URISyntaxException {
        String url = this.host + "/api/create";
        String jsonData = customModelRequest.toString();
        HttpRequest request = this.getRequestBuilderDefault(new URI(url)).header("Accept", "application/json").header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonData, StandardCharsets.UTF_8)).build();
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        String responseString = response.body();
        if (statusCode != 200) {
            throw new OllamaBaseException(statusCode + " - " + responseString);
        }
        if (responseString.contains("error")) {
            throw new OllamaBaseException(responseString);
        }
        if (this.verbose) {
            logger.info(responseString);
        }
    }

    public void deleteModel(String modelName, boolean ignoreIfNotPresent) throws IOException, InterruptedException, OllamaBaseException, URISyntaxException {
        String url = this.host + "/api/delete";
        String jsonData = new ModelRequest(modelName).toString();
        HttpRequest request = this.getRequestBuilderDefault(new URI(url)).method("DELETE", HttpRequest.BodyPublishers.ofString(jsonData, StandardCharsets.UTF_8)).header("Accept", "application/json").header("Content-Type", "application/json").build();
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        String responseBody = response.body();
        if (statusCode == 404 && responseBody.contains("model") && responseBody.contains("not found")) {
            return;
        }
        if (statusCode != 200) {
            throw new OllamaBaseException(statusCode + " - " + responseBody);
        }
    }

    @Deprecated
    public List<Double> generateEmbeddings(String model, String prompt) throws IOException, InterruptedException, OllamaBaseException {
        return this.generateEmbeddings(new OllamaEmbeddingsRequestModel(model, prompt));
    }

    @Deprecated
    public List<Double> generateEmbeddings(OllamaEmbeddingsRequestModel modelRequest) throws IOException, InterruptedException, OllamaBaseException {
        URI uri = URI.create(this.host + "/api/embeddings");
        String jsonData = modelRequest.toString();
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest.Builder requestBuilder = this.getRequestBuilderDefault(uri).header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonData));
        HttpRequest request = requestBuilder.build();
        HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        String responseBody = response.body();
        if (statusCode == 200) {
            OllamaEmbeddingResponseModel embeddingResponse = Utils.getObjectMapper().readValue(responseBody, OllamaEmbeddingResponseModel.class);
            return embeddingResponse.getEmbedding();
        }
        throw new OllamaBaseException(statusCode + " - " + responseBody);
    }

    public OllamaEmbedResponseModel embed(String model, List<String> inputs) throws IOException, InterruptedException, OllamaBaseException {
        return this.embed(new OllamaEmbedRequestModel(model, inputs));
    }

    public OllamaEmbedResponseModel embed(OllamaEmbedRequestModel modelRequest) throws IOException, InterruptedException, OllamaBaseException {
        URI uri = URI.create(this.host + "/api/embed");
        String jsonData = Utils.getObjectMapper().writeValueAsString(modelRequest);
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonData)).build();
        HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        String responseBody = response.body();
        if (statusCode == 200) {
            return Utils.getObjectMapper().readValue(responseBody, OllamaEmbedResponseModel.class);
        }
        throw new OllamaBaseException(statusCode + " - " + responseBody);
    }

    public OllamaResult generate(String model, String prompt, boolean raw, Options options, OllamaStreamHandler responseStreamHandler) throws OllamaBaseException, IOException, InterruptedException {
        OllamaGenerateRequest ollamaRequestModel = new OllamaGenerateRequest(model, prompt);
        ollamaRequestModel.setRaw(raw);
        ollamaRequestModel.setThink(false);
        ollamaRequestModel.setOptions(options.getOptionsMap());
        return this.generateSyncForOllamaRequestModel(ollamaRequestModel, null, responseStreamHandler);
    }

    public OllamaResult generate(String model, String prompt, boolean raw, Options options, OllamaStreamHandler thinkingStreamHandler, OllamaStreamHandler responseStreamHandler) throws OllamaBaseException, IOException, InterruptedException {
        OllamaGenerateRequest ollamaRequestModel = new OllamaGenerateRequest(model, prompt);
        ollamaRequestModel.setRaw(raw);
        ollamaRequestModel.setThink(true);
        ollamaRequestModel.setOptions(options.getOptionsMap());
        return this.generateSyncForOllamaRequestModel(ollamaRequestModel, thinkingStreamHandler, responseStreamHandler);
    }

    public OllamaResult generate(String model, String prompt, boolean raw, boolean think, Options options) throws OllamaBaseException, IOException, InterruptedException {
        if (think) {
            return this.generate(model, prompt, raw, options, null, null);
        }
        return this.generate(model, prompt, raw, options, null);
    }

    public OllamaResult generate(String model, String prompt, Map<String, Object> format) throws OllamaBaseException, IOException, InterruptedException {
        URI uri = URI.create(this.host + "/api/generate");
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", model);
        requestBody.put("prompt", prompt);
        requestBody.put("stream", false);
        requestBody.put("format", format);
        String jsonData = Utils.getObjectMapper().writeValueAsString(requestBody);
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest request = this.getRequestBuilderDefault(uri).header("Accept", "application/json").header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonData)).build();
        if (this.verbose) {
            try {
                String prettyJson = Utils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(Utils.getObjectMapper().readValue(jsonData, Object.class));
                logger.info("Asking model:\n{}", (Object)prettyJson);
            }
            catch (Exception e) {
                logger.info("Asking model: {}", (Object)jsonData);
            }
        }
        HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        String responseBody = response.body();
        if (statusCode == 200) {
            OllamaStructuredResult structuredResult = Utils.getObjectMapper().readValue(responseBody, OllamaStructuredResult.class);
            OllamaResult ollamaResult = new OllamaResult(structuredResult.getResponse(), structuredResult.getThinking(), structuredResult.getResponseTime(), statusCode);
            ollamaResult.setModel(structuredResult.getModel());
            ollamaResult.setCreatedAt(structuredResult.getCreatedAt());
            ollamaResult.setDone(structuredResult.isDone());
            ollamaResult.setDoneReason(structuredResult.getDoneReason());
            ollamaResult.setContext(structuredResult.getContext());
            ollamaResult.setTotalDuration(structuredResult.getTotalDuration());
            ollamaResult.setLoadDuration(structuredResult.getLoadDuration());
            ollamaResult.setPromptEvalCount(structuredResult.getPromptEvalCount());
            ollamaResult.setPromptEvalDuration(structuredResult.getPromptEvalDuration());
            ollamaResult.setEvalCount(structuredResult.getEvalCount());
            ollamaResult.setEvalDuration(structuredResult.getEvalDuration());
            if (this.verbose) {
                logger.info("Model response:\n{}", (Object)ollamaResult);
            }
            return ollamaResult;
        }
        if (this.verbose) {
            logger.info("Model response:\n{}", (Object)Utils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(responseBody));
        }
        throw new OllamaBaseException(statusCode + " - " + responseBody);
    }

    public OllamaToolsResult generateWithTools(String model, String prompt, Options options) throws OllamaBaseException, IOException, InterruptedException, ToolInvocationException {
        boolean raw = true;
        OllamaToolsResult toolResult = new OllamaToolsResult();
        HashMap<ToolFunctionCallSpec, Object> toolResults = new HashMap<ToolFunctionCallSpec, Object>();
        if (!prompt.startsWith("[AVAILABLE_TOOLS]")) {
            Tools.PromptBuilder promptBuilder = new Tools.PromptBuilder();
            for (Tools.ToolSpecification spec : this.toolRegistry.getRegisteredSpecs()) {
                promptBuilder.withToolSpecification(spec);
            }
            promptBuilder.withPrompt(prompt);
            prompt = promptBuilder.build();
        }
        OllamaResult result = this.generate(model, prompt, raw, options, null);
        toolResult.setModelResult(result);
        String toolsResponse = result.getResponse();
        if (toolsResponse.contains("[TOOL_CALLS]")) {
            toolsResponse = toolsResponse.replace("[TOOL_CALLS]", "");
        }
        List toolFunctionCallSpecs = new ArrayList();
        ObjectMapper objectMapper = Utils.getObjectMapper();
        if (!toolsResponse.isEmpty()) {
            try {
                JsonNode jsonNode = objectMapper.readTree(toolsResponse);
            }
            catch (JsonParseException e) {
                logger.warn("Response from model does not contain any tool calls. Returning the response as is.");
                return toolResult;
            }
            toolFunctionCallSpecs = (List)objectMapper.readValue(toolsResponse, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, ToolFunctionCallSpec.class));
        }
        for (ToolFunctionCallSpec toolFunctionCallSpec : toolFunctionCallSpecs) {
            toolResults.put(toolFunctionCallSpec, this.invokeTool(toolFunctionCallSpec));
        }
        toolResult.setToolResults(toolResults);
        return toolResult;
    }

    public OllamaAsyncResultStreamer generateAsync(String model, String prompt, boolean raw, boolean think) {
        OllamaGenerateRequest ollamaRequestModel = new OllamaGenerateRequest(model, prompt);
        ollamaRequestModel.setRaw(raw);
        ollamaRequestModel.setThink(think);
        URI uri = URI.create(this.host + "/api/generate");
        OllamaAsyncResultStreamer ollamaAsyncResultStreamer = new OllamaAsyncResultStreamer(this.getRequestBuilderDefault(uri), ollamaRequestModel, this.requestTimeoutSeconds);
        ollamaAsyncResultStreamer.start();
        return ollamaAsyncResultStreamer;
    }

    public OllamaResult generateWithImageFiles(String model, String prompt, List<File> imageFiles, Options options, OllamaStreamHandler streamHandler) throws OllamaBaseException, IOException, InterruptedException {
        ArrayList<String> images = new ArrayList<String>();
        for (File imageFile : imageFiles) {
            images.add(OllamaAPI.encodeFileToBase64(imageFile));
        }
        OllamaGenerateRequest ollamaRequestModel = new OllamaGenerateRequest(model, prompt, images);
        ollamaRequestModel.setOptions(options.getOptionsMap());
        return this.generateSyncForOllamaRequestModel(ollamaRequestModel, null, streamHandler);
    }

    public OllamaResult generateWithImageFiles(String model, String prompt, List<File> imageFiles, Options options) throws OllamaBaseException, IOException, InterruptedException {
        return this.generateWithImageFiles(model, prompt, imageFiles, options, null);
    }

    public OllamaResult generateWithImageURLs(String model, String prompt, List<String> imageURLs, Options options, OllamaStreamHandler streamHandler) throws OllamaBaseException, IOException, InterruptedException, URISyntaxException {
        ArrayList<String> images = new ArrayList<String>();
        for (String imageURL : imageURLs) {
            images.add(OllamaAPI.encodeByteArrayToBase64(Utils.loadImageBytesFromUrl(imageURL)));
        }
        OllamaGenerateRequest ollamaRequestModel = new OllamaGenerateRequest(model, prompt, images);
        ollamaRequestModel.setOptions(options.getOptionsMap());
        return this.generateSyncForOllamaRequestModel(ollamaRequestModel, null, streamHandler);
    }

    public OllamaResult generateWithImageURLs(String model, String prompt, List<String> imageURLs, Options options) throws OllamaBaseException, IOException, InterruptedException, URISyntaxException {
        return this.generateWithImageURLs(model, prompt, imageURLs, options, null);
    }

    public OllamaResult generateWithImages(String model, String prompt, List<byte[]> images, Options options, OllamaStreamHandler streamHandler) throws OllamaBaseException, IOException, InterruptedException {
        ArrayList<String> encodedImages = new ArrayList<String>();
        for (byte[] image : images) {
            encodedImages.add(OllamaAPI.encodeByteArrayToBase64(image));
        }
        OllamaGenerateRequest ollamaRequestModel = new OllamaGenerateRequest(model, prompt, encodedImages);
        ollamaRequestModel.setOptions(options.getOptionsMap());
        return this.generateSyncForOllamaRequestModel(ollamaRequestModel, null, streamHandler);
    }

    public OllamaResult generateWithImages(String model, String prompt, List<byte[]> images, Options options) throws OllamaBaseException, IOException, InterruptedException {
        return this.generateWithImages(model, prompt, images, options, null);
    }

    public OllamaChatResult chat(String model, List<OllamaChatMessage> messages) throws OllamaBaseException, IOException, InterruptedException, ToolInvocationException {
        OllamaChatRequestBuilder builder = OllamaChatRequestBuilder.getInstance(model);
        return this.chat(builder.withMessages(messages).build());
    }

    public OllamaChatResult chat(OllamaChatRequest request) throws OllamaBaseException, IOException, InterruptedException, ToolInvocationException {
        return this.chat(request, null, null);
    }

    public OllamaChatResult chat(OllamaChatRequest request, OllamaStreamHandler thinkingStreamHandler, OllamaStreamHandler responseStreamHandler) throws OllamaBaseException, IOException, InterruptedException, ToolInvocationException {
        return this.chatStreaming(request, new OllamaChatStreamObserver(thinkingStreamHandler, responseStreamHandler));
    }

    public OllamaChatResult chatStreaming(OllamaChatRequest request, OllamaTokenHandler tokenHandler) throws OllamaBaseException, IOException, InterruptedException, ToolInvocationException {
        OllamaChatResult result;
        OllamaChatEndpointCaller requestCaller = new OllamaChatEndpointCaller(this.host, this.auth, this.requestTimeoutSeconds, this.verbose);
        request.setTools(this.toolRegistry.getRegisteredSpecs().stream().map(Tools.ToolSpecification::getToolPrompt).collect(Collectors.toList()));
        if (tokenHandler != null) {
            request.setStream(true);
            result = requestCaller.call(request, tokenHandler);
        } else {
            result = requestCaller.callSync(request);
        }
        List<OllamaChatToolCalls> toolCalls = result.getResponseModel().getMessage().getToolCalls();
        for (int toolCallTries = 0; toolCalls != null && !toolCalls.isEmpty() && toolCallTries < this.maxChatToolCallRetries; ++toolCallTries) {
            for (OllamaChatToolCalls toolCall : toolCalls) {
                String toolName = toolCall.getFunction().getName();
                ToolFunction toolFunction = this.toolRegistry.getToolFunction(toolName);
                if (toolFunction == null) {
                    throw new ToolInvocationException("Tool function not found: " + toolName);
                }
                Map<String, Object> arguments = toolCall.getFunction().getArguments();
                Object res = toolFunction.apply(arguments);
                String argumentKeys = arguments.keySet().stream().map(Object::toString).collect(Collectors.joining(", "));
                request.getMessages().add(new OllamaChatMessage(OllamaChatMessageRole.TOOL, "[TOOL_RESULTS] " + toolName + "(" + argumentKeys + "): " + String.valueOf(res) + " [/TOOL_RESULTS]"));
            }
            result = tokenHandler != null ? requestCaller.call(request, tokenHandler) : requestCaller.callSync(request);
            toolCalls = result.getResponseModel().getMessage().getToolCalls();
        }
        return result;
    }

    public void registerTool(Tools.ToolSpecification toolSpecification) {
        this.toolRegistry.addTool(toolSpecification.getFunctionName(), toolSpecification);
        if (this.verbose) {
            logger.debug("Registered tool: {}", (Object)toolSpecification.getFunctionName());
        }
    }

    public void registerTools(List<Tools.ToolSpecification> toolSpecifications) {
        for (Tools.ToolSpecification toolSpecification : toolSpecifications) {
            this.toolRegistry.addTool(toolSpecification.getFunctionName(), toolSpecification);
        }
    }

    public void deregisterTools() {
        this.toolRegistry.clear();
        if (this.verbose) {
            logger.debug("All tools have been deregistered.");
        }
    }

    public void registerAnnotatedTools() {
        try {
            Class<?>[] providers;
            Class<?> callerClass = null;
            try {
                callerClass = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            OllamaToolService ollamaToolServiceAnnotation = callerClass.getDeclaredAnnotation(OllamaToolService.class);
            if (ollamaToolServiceAnnotation == null) {
                throw new IllegalStateException(String.valueOf(callerClass) + " is not annotated as " + String.valueOf(OllamaToolService.class));
            }
            for (Class<?> provider : providers = ollamaToolServiceAnnotation.providers()) {
                this.registerAnnotatedTools(provider.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerAnnotatedTools(Object object) {
        Method[] methods;
        Class<?> objectClass = object.getClass();
        for (Method m : methods = objectClass.getMethods()) {
            ToolSpec toolSpec = m.getDeclaredAnnotation(ToolSpec.class);
            if (toolSpec == null) continue;
            String operationName = !toolSpec.name().isBlank() ? toolSpec.name() : m.getName();
            String operationDesc = !toolSpec.desc().isBlank() ? toolSpec.desc() : operationName;
            Tools.PropsBuilder propsBuilder = new Tools.PropsBuilder();
            LinkedHashMap<String, String> methodParams = new LinkedHashMap<String, String>();
            for (Parameter parameter : m.getParameters()) {
                ToolProperty toolPropertyAnn = parameter.getDeclaredAnnotation(ToolProperty.class);
                String propType = parameter.getType().getTypeName();
                if (toolPropertyAnn == null) {
                    methodParams.put(parameter.getName(), null);
                    continue;
                }
                String propName = !toolPropertyAnn.name().isBlank() ? toolPropertyAnn.name() : parameter.getName();
                methodParams.put(propName, propType);
                propsBuilder.withProperty(propName, Tools.PromptFuncDefinition.Property.builder().type(propType).description(toolPropertyAnn.desc()).required(toolPropertyAnn.required()).build());
            }
            Map<String, Tools.PromptFuncDefinition.Property> params = propsBuilder.build();
            List<String> reqProps = params.entrySet().stream().filter(e -> ((Tools.PromptFuncDefinition.Property)e.getValue()).isRequired()).map(Map.Entry::getKey).collect(Collectors.toList());
            Tools.ToolSpecification toolSpecification = Tools.ToolSpecification.builder().functionName(operationName).functionDescription(operationDesc).toolPrompt(Tools.PromptFuncDefinition.builder().type("function").function(Tools.PromptFuncDefinition.PromptFuncSpec.builder().name(operationName).description(operationDesc).parameters(Tools.PromptFuncDefinition.Parameters.builder().type("object").properties(params).required(reqProps).build()).build()).build()).build();
            ReflectionalToolFunction reflectionalToolFunction = new ReflectionalToolFunction(object, m, methodParams);
            toolSpecification.setToolFunction(reflectionalToolFunction);
            this.toolRegistry.addTool(toolSpecification.getFunctionName(), toolSpecification);
        }
    }

    public OllamaChatMessageRole addCustomRole(String roleName) {
        return OllamaChatMessageRole.newCustomRole(roleName);
    }

    public List<OllamaChatMessageRole> listRoles() {
        return OllamaChatMessageRole.getRoles();
    }

    public OllamaChatMessageRole getRole(String roleName) throws RoleNotFoundException {
        return OllamaChatMessageRole.getRole(roleName);
    }

    private static String encodeFileToBase64(File file) throws IOException {
        return Base64.getEncoder().encodeToString(Files.readAllBytes(file.toPath()));
    }

    private static String encodeByteArrayToBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    private OllamaResult generateSyncForOllamaRequestModel(OllamaGenerateRequest ollamaRequestModel, OllamaStreamHandler thinkingStreamHandler, OllamaStreamHandler responseStreamHandler) throws OllamaBaseException, IOException, InterruptedException {
        OllamaResult result;
        OllamaGenerateEndpointCaller requestCaller = new OllamaGenerateEndpointCaller(this.host, this.auth, this.requestTimeoutSeconds, this.verbose);
        if (responseStreamHandler != null) {
            ollamaRequestModel.setStream(true);
            result = requestCaller.call(ollamaRequestModel, thinkingStreamHandler, responseStreamHandler);
        } else {
            result = requestCaller.callSync(ollamaRequestModel);
        }
        return result;
    }

    private HttpRequest.Builder getRequestBuilderDefault(URI uri) {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(uri).header("Content-Type", "application/json").timeout(Duration.ofSeconds(this.requestTimeoutSeconds));
        if (this.isBasicAuthCredentialsSet()) {
            requestBuilder.header("Authorization", this.auth.getAuthHeaderValue());
        }
        return requestBuilder;
    }

    private boolean isBasicAuthCredentialsSet() {
        return this.auth != null;
    }

    private Object invokeTool(ToolFunctionCallSpec toolFunctionCallSpec) throws ToolInvocationException {
        try {
            String methodName = toolFunctionCallSpec.getName();
            Map<String, Object> arguments = toolFunctionCallSpec.getArguments();
            ToolFunction function = this.toolRegistry.getToolFunction(methodName);
            if (this.verbose) {
                logger.debug("Invoking function {} with arguments {}", (Object)methodName, (Object)arguments);
            }
            if (function == null) {
                throw new ToolNotFoundException("No such tool: " + methodName + ". Please register the tool before invoking it.");
            }
            return function.apply(arguments);
        }
        catch (Exception e) {
            throw new ToolInvocationException("Failed to invoke tool: " + toolFunctionCallSpec.getName(), e);
        }
    }

    @Generated
    public void setRequestTimeoutSeconds(long requestTimeoutSeconds) {
        this.requestTimeoutSeconds = requestTimeoutSeconds;
    }

    @Generated
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Generated
    public void setMaxChatToolCallRetries(int maxChatToolCallRetries) {
        this.maxChatToolCallRetries = maxChatToolCallRetries;
    }

    @Generated
    public void setNumberOfRetriesForModelPull(int numberOfRetriesForModelPull) {
        this.numberOfRetriesForModelPull = numberOfRetriesForModelPull;
    }
}

