/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api;

import java.util.OptionalInt;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.state.api.SavepointWriterOperatorFactory;
import org.apache.flink.state.api.StateBootstrapTransformation;
import org.apache.flink.state.api.WindowedStateTransformation;
import org.apache.flink.state.api.functions.KeyedStateBootstrapFunction;
import org.apache.flink.state.api.output.operators.KeyedStateBootstrapOperator;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.windows.Window;

@PublicEvolving
public class KeyedStateTransformation<K, T> {
    private final DataStream<T> stream;
    private final OptionalInt operatorMaxParallelism;
    private final KeySelector<T, K> keySelector;
    private final TypeInformation<K> keyType;

    KeyedStateTransformation(DataStream<T> stream, OptionalInt operatorMaxParallelism, KeySelector<T, K> keySelector, TypeInformation<K> keyType) {
        this.stream = stream;
        this.operatorMaxParallelism = operatorMaxParallelism;
        this.keySelector = keySelector;
        this.keyType = keyType;
    }

    public StateBootstrapTransformation<T> transform(KeyedStateBootstrapFunction<K, T> processFunction) {
        SavepointWriterOperatorFactory factory = (timestamp, path) -> SimpleOperatorFactory.of(new KeyedStateBootstrapOperator(timestamp, path, processFunction));
        return this.transform(factory);
    }

    public StateBootstrapTransformation<T> transform(SavepointWriterOperatorFactory factory) {
        return new StateBootstrapTransformation<T>(this.stream, this.operatorMaxParallelism, factory, this.keySelector, this.keyType);
    }

    public <W extends Window> WindowedStateTransformation<T, K, W> window(WindowAssigner<? super T, W> assigner) {
        return new WindowedStateTransformation<T, K, W>(this.stream, this.operatorMaxParallelism, this.keySelector, this.keyType, assigner);
    }
}

