/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableFunctionScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalCorrelate;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalValues;
import org.apache.flink.table.planner.plan.rules.physical.stream.ImmutableStreamPhysicalConstantTableFunctionScanRule;
import org.immutables.value.Value;
import scala.Option;

@Value.Enclosing
public class StreamPhysicalConstantTableFunctionScanRule
extends RelRule<StreamPhysicalConstantTableFunctionScanRuleConfig> {
    public static final StreamPhysicalConstantTableFunctionScanRule INSTANCE = StreamPhysicalConstantTableFunctionScanRuleConfig.DEFAULT.toRule();

    protected StreamPhysicalConstantTableFunctionScanRule(StreamPhysicalConstantTableFunctionScanRuleConfig config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalTableFunctionScan scan = (FlinkLogicalTableFunctionScan)call.rel(0);
        return !RexUtil.containsInputRef(scan.getCall()) && scan.getInputs().isEmpty();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalTableFunctionScan scan = (FlinkLogicalTableFunctionScan)call.rel(0);
        RelOptCluster cluster = scan.getCluster();
        RelTraitSet traitSet = call.getPlanner().emptyTraitSet().replace(FlinkConventions.STREAM_PHYSICAL());
        StreamPhysicalValues values = new StreamPhysicalValues(cluster, traitSet, ImmutableList.of(ImmutableList.of()), cluster.getTypeFactory().createStructType(ImmutableList.of(), ImmutableList.of()));
        StreamPhysicalCorrelate correlate = new StreamPhysicalCorrelate(cluster, traitSet, values, scan, (Option<RexNode>)Option.empty(), scan.getRowType(), JoinRelType.INNER);
        call.transformTo(correlate);
    }

    @Value.Immutable(singleton=false)
    public static interface StreamPhysicalConstantTableFunctionScanRuleConfig
    extends RelRule.Config {
        public static final StreamPhysicalConstantTableFunctionScanRuleConfig DEFAULT = ImmutableStreamPhysicalConstantTableFunctionScanRule.StreamPhysicalConstantTableFunctionScanRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(FlinkLogicalTableFunctionScan.class).anyInputs()).withDescription("StreamPhysicalConstantTableFunctionScanRule").as(StreamPhysicalConstantTableFunctionScanRuleConfig.class);

        @Override
        default public StreamPhysicalConstantTableFunctionScanRule toRule() {
            return new StreamPhysicalConstantTableFunctionScanRule(this);
        }
    }
}

