/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.legacy.api.TableSchema;
import org.apache.flink.table.legacy.api.constraints.UniqueConstraint;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.connectors.DynamicSourceUtils;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.nodes.exec.spec.OverSpec;
import org.apache.flink.table.planner.plan.nodes.physical.common.CommonPhysicalJoin;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalCalcBase;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalChangelogNormalize;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalCorrelateBase;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalDataStreamScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalDropUpdateBefore;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalExchange;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalExpand;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalGroupAggregateBase;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalLegacySink;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalLegacyTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalLimit;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalLookupJoin;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalMatch;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalMiniBatchAssigner;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalOverAggregateBase;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRank;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalSink;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalSort;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalSortLimit;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalTemporalSort;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalUnion;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalValues;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalWatermarkAssigner;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalWindowAggregateBase;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalWindowDeduplicate;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalWindowRank;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalWindowTableFunction;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.utils.ChangelogPlanUtils;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;
import org.apache.flink.table.planner.plan.utils.JoinUtil;
import org.apache.flink.table.planner.plan.utils.OverAggregateUtil;
import org.apache.flink.table.planner.plan.utils.RankProcessStrategy;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.stream.utils.JoinInputSideSpec;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import scala.collection.JavaConverters;

public class StreamNonDeterministicUpdatePlanVisitor {
    private static final ImmutableBitSet NO_REQUIRED_DETERMINISM = ImmutableBitSet.of();
    private static final String NON_DETERMINISTIC_CONDITION_ERROR_MSG_TEMPLATE = "There exists non deterministic function: '%s' in condition: '%s' which may cause wrong result in update pipeline.";

    public StreamPhysicalRel visit(StreamPhysicalRel rel) {
        return this.visit(rel, NO_REQUIRED_DETERMINISM);
    }

    public StreamPhysicalRel visit(StreamPhysicalRel rel, ImmutableBitSet requireDeterminism) {
        if (rel instanceof StreamPhysicalSink) {
            return this.visitSink((StreamPhysicalSink)rel, requireDeterminism);
        }
        if (rel instanceof StreamPhysicalLegacySink) {
            return this.visitLegacySink((StreamPhysicalLegacySink)rel, requireDeterminism);
        }
        if (rel instanceof StreamPhysicalCalcBase) {
            return this.visitCalc((StreamPhysicalCalcBase)rel, requireDeterminism);
        }
        if (rel instanceof StreamPhysicalCorrelateBase) {
            return this.visitCorrelate((StreamPhysicalCorrelateBase)rel, requireDeterminism);
        }
        if (rel instanceof StreamPhysicalLookupJoin) {
            return this.visitLookupJoin((StreamPhysicalLookupJoin)rel, requireDeterminism);
        }
        if (rel instanceof StreamPhysicalTableSourceScan) {
            return this.visitTableSourceScan((StreamPhysicalTableSourceScan)rel, requireDeterminism);
        }
        if (rel instanceof StreamPhysicalLegacyTableSourceScan || rel instanceof StreamPhysicalDataStreamScan || rel instanceof StreamPhysicalValues) {
            return rel;
        }
        if (rel instanceof StreamPhysicalGroupAggregateBase) {
            return this.visitGroupAggregate((StreamPhysicalGroupAggregateBase)rel, requireDeterminism);
        }
        if (rel instanceof StreamPhysicalWindowAggregateBase) {
            return this.visitWindowAggregate((StreamPhysicalWindowAggregateBase)rel, requireDeterminism);
        }
        if (rel instanceof StreamPhysicalExpand) {
            return this.visitExpand((StreamPhysicalExpand)rel, requireDeterminism);
        }
        if (rel instanceof CommonPhysicalJoin) {
            return this.visitJoin((CommonPhysicalJoin)((Object)rel), requireDeterminism);
        }
        if (rel instanceof StreamPhysicalOverAggregateBase) {
            return this.visitOverAggregate((StreamPhysicalOverAggregateBase)rel, requireDeterminism);
        }
        if (rel instanceof StreamPhysicalRank) {
            return this.visitRank((StreamPhysicalRank)rel, requireDeterminism);
        }
        if (rel instanceof StreamPhysicalWindowDeduplicate) {
            return this.visitWindowDeduplicate((StreamPhysicalWindowDeduplicate)rel, requireDeterminism);
        }
        if (rel instanceof StreamPhysicalWindowRank) {
            return this.visitWindowRank((StreamPhysicalWindowRank)rel, requireDeterminism);
        }
        if (rel instanceof StreamPhysicalWindowTableFunction) {
            return this.visitWindowTableFunction((StreamPhysicalWindowTableFunction)rel, requireDeterminism);
        }
        if (rel instanceof StreamPhysicalChangelogNormalize || rel instanceof StreamPhysicalDropUpdateBefore || rel instanceof StreamPhysicalMiniBatchAssigner || rel instanceof StreamPhysicalUnion || rel instanceof StreamPhysicalSort || rel instanceof StreamPhysicalLimit || rel instanceof StreamPhysicalSortLimit || rel instanceof StreamPhysicalTemporalSort || rel instanceof StreamPhysicalWatermarkAssigner || rel instanceof StreamPhysicalExchange) {
            return this.transmitDeterminismRequirement(rel, requireDeterminism);
        }
        if (rel instanceof StreamPhysicalMatch) {
            return this.visitMatch((StreamPhysicalMatch)rel, requireDeterminism);
        }
        throw new UnsupportedOperationException(String.format("Unsupported to visit node %s, please add the visit implementation if it is a newly added stream physical node.", rel.getClass().getSimpleName()));
    }

    private StreamPhysicalRel visitSink(StreamPhysicalSink sink, ImmutableBitSet requireDeterminism) {
        if (this.inputInsertOnly(sink)) {
            return this.transmitDeterminismRequirement(sink, NO_REQUIRED_DETERMINISM);
        }
        int[] primaryKey = sink.contextResolvedTable().getResolvedSchema().getPrimaryKeyIndexes();
        ImmutableBitSet requireInputDeterminism = sink.upsertMaterialize() || null == primaryKey || primaryKey.length == 0 ? ImmutableBitSet.range(sink.getInput().getRowType().getFieldCount()) : ImmutableBitSet.of(primaryKey);
        return this.transmitDeterminismRequirement(sink, requireInputDeterminism);
    }

    private StreamPhysicalRel visitLegacySink(StreamPhysicalLegacySink<?> sink, ImmutableBitSet requireDeterminism) {
        if (this.inputInsertOnly(sink)) {
            return this.transmitDeterminismRequirement(sink, NO_REQUIRED_DETERMINISM);
        }
        TableSchema tableSchema = sink.sink().getTableSchema();
        Optional primaryKey = tableSchema.getPrimaryKey();
        List<String> columns = Arrays.asList(tableSchema.getFieldNames());
        ImmutableBitSet requireInputDeterminism = primaryKey.isPresent() ? ImmutableBitSet.of(((UniqueConstraint)primaryKey.get()).getColumns().stream().map(columns::indexOf).collect(Collectors.toList())) : ImmutableBitSet.range(columns.size());
        return this.transmitDeterminismRequirement(sink, requireInputDeterminism);
    }

    private StreamPhysicalRel visitCalc(StreamPhysicalCalcBase calc, ImmutableBitSet requireDeterminism) {
        if (this.inputInsertOnly(calc) || requireDeterminism.isEmpty()) {
            return this.transmitDeterminismRequirement(calc, NO_REQUIRED_DETERMINISM);
        }
        this.checkNonDeterministicRexProgram(requireDeterminism, calc.getProgram(), calc);
        List<RexNode> projects = calc.getProgram().getProjectList().stream().map(expr -> calc.getProgram().expandLocalRef((RexLocalRef)expr)).collect(Collectors.toList());
        Map<Integer, List<Integer>> outFromSourcePos = this.extractSourceMapping(projects);
        List<Integer> conv2Inputs = requireDeterminism.toList().stream().map(out -> Optional.ofNullable((List)outFromSourcePos.get(out)).orElseThrow(() -> new TableException(String.format("Invalid pos:%d over projection:%s", out, calc.getProgram())))).flatMap(Collection::stream).filter(index -> index != -1).distinct().collect(Collectors.toList());
        return this.transmitDeterminismRequirement(calc, ImmutableBitSet.of(conv2Inputs));
    }

    private StreamPhysicalRel visitCorrelate(StreamPhysicalCorrelateBase correlate, ImmutableBitSet requireDeterminism) {
        List<Integer> fromLeft;
        List<Integer> unsatisfiedColumns;
        if (this.inputInsertOnly(correlate) || requireDeterminism.isEmpty()) {
            return this.transmitDeterminismRequirement(correlate, NO_REQUIRED_DETERMINISM);
        }
        if (correlate.condition().isDefined()) {
            RexNode rexNode = (RexNode)correlate.condition().get();
            this.checkNonDeterministicCondition(rexNode, correlate);
        }
        int leftFieldCnt = correlate.inputRel().getRowType().getFieldCount();
        Optional<String> ndCall = FlinkRexUtil.getNonDeterministicCallName(correlate.scan().getCall());
        if (ndCall.isPresent() && !(unsatisfiedColumns = requireDeterminism.toList().stream().filter(index -> index >= leftFieldCnt).collect(Collectors.toList())).isEmpty()) {
            this.throwNonDeterministicColumnsError(unsatisfiedColumns, correlate.getRowType(), correlate, null, ndCall);
        }
        if ((fromLeft = requireDeterminism.toList().stream().filter(index -> index < leftFieldCnt).collect(Collectors.toList())).isEmpty()) {
            return this.transmitDeterminismRequirement(correlate, NO_REQUIRED_DETERMINISM);
        }
        return this.transmitDeterminismRequirement(correlate, ImmutableBitSet.of(fromLeft));
    }

    /*
     * Unable to fully structure code
     */
    private StreamPhysicalRel visitLookupJoin(StreamPhysicalLookupJoin lookupJoin, ImmutableBitSet requireDeterminism) {
        block5: {
            block4: {
                if (this.inputInsertOnly(lookupJoin) || requireDeterminism.isEmpty()) {
                    return this.transmitDeterminismRequirement(lookupJoin, StreamNonDeterministicUpdatePlanVisitor.NO_REQUIRED_DETERMINISM);
                }
                JavaScalaConversionUtil.toJava(lookupJoin.finalPreFilterCondition()).ifPresent((Consumer<RexNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$visitLookupJoin$6(org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalLookupJoin org.apache.calcite.rex.RexNode ), (Lorg/apache/calcite/rex/RexNode;)V)((StreamNonDeterministicUpdatePlanVisitor)this, (StreamPhysicalLookupJoin)lookupJoin));
                JavaScalaConversionUtil.toJava(lookupJoin.finalRemainingCondition()).ifPresent((Consumer<RexNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$visitLookupJoin$7(org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalLookupJoin org.apache.calcite.rex.RexNode ), (Lorg/apache/calcite/rex/RexNode;)V)((StreamNonDeterministicUpdatePlanVisitor)this, (StreamPhysicalLookupJoin)lookupJoin));
                JavaScalaConversionUtil.toJava(lookupJoin.calcOnTemporalTable()).ifPresent((Consumer<RexProgram>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$visitLookupJoin$8(org.apache.calcite.util.ImmutableBitSet org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalLookupJoin org.apache.calcite.rex.RexProgram ), (Lorg/apache/calcite/rex/RexProgram;)V)((StreamNonDeterministicUpdatePlanVisitor)this, (ImmutableBitSet)requireDeterminism, (StreamPhysicalLookupJoin)lookupJoin));
                leftFieldCnt = lookupJoin.getInput().getRowType().getFieldCount();
                requireRight = requireDeterminism.toList().stream().filter((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$visitLookupJoin$9(int java.lang.Integer ), (Ljava/lang/Integer;)Z)((int)leftFieldCnt)).collect(Collectors.toList());
                omitUpsertMaterialize = false;
                if (!requireRight.isEmpty()) break block4;
                omitUpsertMaterialize = true;
                break block5;
            }
            outputPkIdx = lookupJoin.getOutputIndexesOfTemporalTablePrimaryKey();
            outputPkBitSet = ImmutableBitSet.of(outputPkIdx);
            if (!Arrays.stream(outputPkIdx).allMatch((IntPredicate)LambdaMetafactory.metafactory(null, null, null, (I)Z, lambda$visitLookupJoin$10(org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalLookupJoin int ), (I)Z)((StreamPhysicalLookupJoin)lookupJoin))) ** GOTO lbl-1000
            if (requireRight.stream().allMatch((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, get(int ), (Ljava/lang/Integer;)Z)((ImmutableBitSet)outputPkBitSet))) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            omitUpsertMaterialize = v0;
        }
        requireLeft = requireDeterminism.toList().stream().filter((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$visitLookupJoin$11(int java.lang.Integer ), (Ljava/lang/Integer;)Z)((int)leftFieldCnt)).collect(Collectors.toList());
        if (omitUpsertMaterialize) {
            return this.transmitDeterminismRequirement(lookupJoin, ImmutableBitSet.of(requireLeft));
        }
        return this.transmitDeterminismRequirement(lookupJoin.copy(true), ImmutableBitSet.of(requireLeft));
    }

    private StreamPhysicalRel visitTableSourceScan(StreamPhysicalTableSourceScan tableScan, ImmutableBitSet requireDeterminism) {
        if (!requireDeterminism.isEmpty()) {
            boolean insertOnly = tableScan.tableSource().getChangelogMode().containsOnly(RowKind.INSERT);
            boolean supportsReadingMetadata = tableScan.tableSource() instanceof SupportsReadingMetadata;
            if (!insertOnly && supportsReadingMetadata) {
                TableSourceTable sourceTable = tableScan.getTable().unwrap(TableSourceTable.class);
                TableConfig tableConfig = ShortcutUtils.unwrapContext(tableScan.getCluster()).getTableConfig();
                assert (sourceTable != null);
                ResolvedSchema resolvedSchema = sourceTable.contextResolvedTable().getResolvedSchema();
                if (!DynamicSourceUtils.changelogNormalizeEnabled(tableScan.eventTimeSnapshotRequired(), resolvedSchema, sourceTable.tableSource(), tableConfig)) {
                    List<Column.MetadataColumn> metadataColumns = DynamicSourceUtils.extractMetadataColumns(sourceTable.contextResolvedTable().getResolvedSchema());
                    Set metaColumnSet = metadataColumns.stream().map(Column::getName).collect(Collectors.toSet());
                    List<String> columns = tableScan.getRowType().getFieldNames();
                    ArrayList<String> metadataCauseErr = new ArrayList<String>();
                    for (int index = 0; index < columns.size(); ++index) {
                        String column = columns.get(index);
                        if (!metaColumnSet.contains(column) || !requireDeterminism.get(index)) continue;
                        metadataCauseErr.add(column);
                    }
                    if (!metadataCauseErr.isEmpty()) {
                        String errorMsg = "The metadata column(s): '" + String.join((CharSequence)", ", metadataCauseErr.toArray(new String[0])) + "' in cdc source may cause wrong result or error on downstream operators, please consider removing these columns or use a non-cdc source that only has insert messages.\nsource node:\n" + FlinkRelOptUtil.toString(tableScan, SqlExplainLevel.DIGEST_ATTRIBUTES, false, true, false, true, false);
                        throw new TableException(errorMsg);
                    }
                }
            }
        }
        return tableScan;
    }

    private StreamPhysicalRel visitGroupAggregate(StreamPhysicalGroupAggregateBase groupAgg, ImmutableBitSet requireDeterminism) {
        if (this.inputInsertOnly(groupAgg)) {
            if (!requireDeterminism.isEmpty()) {
                this.checkUnsatisfiedDeterminism(requireDeterminism, groupAgg.grouping().length, JavaConverters.seqAsJavaList(groupAgg.aggCalls()), groupAgg.getRowType(), groupAgg);
            }
            return this.transmitDeterminismRequirement(groupAgg, NO_REQUIRED_DETERMINISM);
        }
        return this.transmitDeterminismRequirement(groupAgg, ImmutableBitSet.range(groupAgg.getInput().getRowType().getFieldCount()));
    }

    private StreamPhysicalRel visitWindowAggregate(StreamPhysicalWindowAggregateBase windowAgg, ImmutableBitSet requireDeterminism) {
        if (this.inputInsertOnly(windowAgg)) {
            if (!requireDeterminism.isEmpty()) {
                this.checkUnsatisfiedDeterminism(requireDeterminism, windowAgg.grouping().length, JavaConverters.seqAsJavaList(windowAgg.aggCalls()), windowAgg.getRowType(), windowAgg);
            }
            return this.transmitDeterminismRequirement(windowAgg, NO_REQUIRED_DETERMINISM);
        }
        return this.transmitDeterminismRequirement(windowAgg, ImmutableBitSet.range(windowAgg.getInput().getRowType().getFieldCount()));
    }

    private StreamPhysicalRel visitExpand(StreamPhysicalExpand expand, ImmutableBitSet requireDeterminism) {
        return this.transmitDeterminismRequirement(expand, requireDeterminism.except(ImmutableBitSet.of(expand.expandIdIndex())));
    }

    private StreamPhysicalRel visitJoin(CommonPhysicalJoin join, ImmutableBitSet requireDeterminism) {
        StreamPhysicalRel leftRel = (StreamPhysicalRel)join.getLeft();
        StreamPhysicalRel rightRel = (StreamPhysicalRel)join.getRight();
        boolean leftInputHasUpdate = !this.inputInsertOnly(leftRel);
        boolean rightInputHasUpdate = !this.inputInsertOnly(rightRel);
        boolean innerOrSemi = join.joinSpec().getJoinType() == FlinkJoinType.INNER || join.joinSpec().getJoinType() == FlinkJoinType.SEMI;
        Optional<String> ndCall = FlinkRexUtil.getNonDeterministicCallName(join.getCondition());
        if ((leftInputHasUpdate || rightInputHasUpdate || !innerOrSemi) && ndCall.isPresent()) {
            this.throwNonDeterministicConditionError(ndCall.get(), join.getCondition(), (StreamPhysicalRel)((Object)join));
        }
        int leftFieldCnt = leftRel.getRowType().getFieldCount();
        StreamPhysicalRel newLeft = this.visitJoinChild(requireDeterminism, leftRel, leftInputHasUpdate, leftFieldCnt, true, join.joinSpec().getLeftKeys(), JavaConverters.seqAsJavaList(join.getUpsertKeys(leftRel, join.joinSpec().getLeftKeys())));
        StreamPhysicalRel newRight = this.visitJoinChild(requireDeterminism, rightRel, rightInputHasUpdate, leftFieldCnt, false, join.joinSpec().getRightKeys(), JavaConverters.seqAsJavaList(join.getUpsertKeys(rightRel, join.joinSpec().getRightKeys())));
        return (StreamPhysicalRel)((Object)join.copy(join.getTraitSet(), join.getCondition(), newLeft, newRight, join.getJoinType(), join.isSemiJoin()));
    }

    private StreamPhysicalRel visitOverAggregate(StreamPhysicalOverAggregateBase overAgg, ImmutableBitSet requireDeterminism) {
        if (this.inputInsertOnly(overAgg)) {
            if (!requireDeterminism.isEmpty()) {
                int inputFieldCnt = overAgg.getInput().getRowType().getFieldCount();
                OverSpec overSpec = OverAggregateUtil.createOverSpec(overAgg.logicWindow());
                int aggOutputIndex = inputFieldCnt;
                for (OverSpec.GroupSpec groupSpec : overSpec.getGroups()) {
                    this.checkUnsatisfiedDeterminism(requireDeterminism, aggOutputIndex, groupSpec.getAggCalls(), overAgg.getRowType(), overAgg);
                    aggOutputIndex += groupSpec.getAggCalls().size();
                }
            }
            return this.transmitDeterminismRequirement(overAgg, NO_REQUIRED_DETERMINISM);
        }
        return this.transmitDeterminismRequirement(overAgg, this.mappingRequireDeterminismToInput(requireDeterminism, overAgg));
    }

    private StreamPhysicalRel visitRank(StreamPhysicalRank rank, ImmutableBitSet requireDeterminism) {
        if (this.inputInsertOnly(rank)) {
            return this.transmitDeterminismRequirement(rank, NO_REQUIRED_DETERMINISM);
        }
        int inputFieldCnt = rank.getInput().getRowType().getFieldCount();
        if (rank.rankStrategy() instanceof RankProcessStrategy.UpdateFastStrategy) {
            ImmutableBitSet.Builder bitSetBuilder = ImmutableBitSet.builder();
            rank.partitionKey().toList().forEach(bitSetBuilder::set);
            rank.orderKey().getKeys().toIntegerList().forEach(bitSetBuilder::set);
            if (rank.outputRankNumber()) {
                bitSetBuilder.set(inputFieldCnt);
            }
            return this.transmitDeterminismRequirement(rank, requireDeterminism.except(bitSetBuilder.build()));
        }
        if (rank.rankStrategy() instanceof RankProcessStrategy.RetractStrategy) {
            return this.transmitDeterminismRequirement(rank, ImmutableBitSet.range(inputFieldCnt));
        }
        throw new TableException(String.format("Can not infer the determinism for unsupported rank strategy: %s, this is a bug, please file an issue.", rank.rankStrategy()));
    }

    private StreamPhysicalRel visitWindowDeduplicate(StreamPhysicalWindowDeduplicate winDedup, ImmutableBitSet requireDeterminism) {
        if (this.inputInsertOnly(winDedup)) {
            return this.transmitDeterminismRequirement(winDedup, NO_REQUIRED_DETERMINISM);
        }
        return this.transmitDeterminismRequirement(winDedup, requireDeterminism.clear(winDedup.orderKey()).union(ImmutableBitSet.of(winDedup.partitionKeys())));
    }

    private StreamPhysicalRel visitWindowRank(StreamPhysicalWindowRank winRank, ImmutableBitSet requireDeterminism) {
        if (this.inputInsertOnly(winRank)) {
            return this.transmitDeterminismRequirement(winRank, NO_REQUIRED_DETERMINISM);
        }
        int inputFieldCnt = winRank.getInput().getRowType().getFieldCount();
        return this.transmitDeterminismRequirement(winRank, requireDeterminism.intersect(ImmutableBitSet.range(inputFieldCnt)).union(winRank.partitionKey()));
    }

    private StreamPhysicalRel visitWindowTableFunction(StreamPhysicalWindowTableFunction winTVF, ImmutableBitSet requireDeterminism) {
        if (this.inputInsertOnly(winTVF)) {
            return this.transmitDeterminismRequirement(winTVF, NO_REQUIRED_DETERMINISM);
        }
        return this.transmitDeterminismRequirement(winTVF, requireDeterminism.intersect(ImmutableBitSet.range(winTVF.getInput().getRowType().getFieldCount())));
    }

    private StreamPhysicalRel visitMatch(StreamPhysicalMatch match, ImmutableBitSet requireDeterminism) {
        if (this.inputInsertOnly(match)) {
            return this.transmitDeterminismRequirement(match, NO_REQUIRED_DETERMINISM);
        }
        throw new UnsupportedOperationException("Unsupported to resolve non-deterministic issue in match-recognize when input has updates.");
    }

    private boolean inputInsertOnly(StreamPhysicalRel rel) {
        return ChangelogPlanUtils.inputInsertOnly(rel);
    }

    private StreamPhysicalRel transmitDeterminismRequirement(StreamPhysicalRel parent, ImmutableBitSet requireDeterminism) {
        List<RelNode> newChildren = this.visitInputs(parent, requireDeterminism);
        return (StreamPhysicalRel)parent.copy(parent.getTraitSet(), newChildren);
    }

    private List<RelNode> visitInputs(StreamPhysicalRel parent, ImmutableBitSet requireDeterminism) {
        ArrayList<RelNode> newChildren = new ArrayList<RelNode>();
        for (int index = 0; index < parent.getInputs().size(); ++index) {
            StreamPhysicalRel input = (StreamPhysicalRel)parent.getInput(index);
            newChildren.add(this.visit(input, this.requireDeterminismExcludeUpsertKey(input, requireDeterminism)));
        }
        return newChildren;
    }

    private StreamPhysicalRel visitJoinChild(ImmutableBitSet requireDeterminism, StreamPhysicalRel rel, boolean inputHasUpdate, int leftFieldCnt, boolean isLeft, int[] joinKeys, List<int[]> inputUniqueKeys) {
        JoinInputSideSpec joinInputSideSpec = JoinUtil.analyzeJoinInput(ShortcutUtils.unwrapClassLoader(rel), (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)FlinkTypeFactory.toLogicalRowType(rel.getRowType())), joinKeys, inputUniqueKeys);
        ImmutableBitSet inputRequireDeterminism = inputHasUpdate ? (joinInputSideSpec.hasUniqueKey() || joinInputSideSpec.joinKeyContainsUniqueKey() ? (isLeft ? ImmutableBitSet.of(requireDeterminism.toList().stream().filter(index -> index < leftFieldCnt).collect(Collectors.toList())) : ImmutableBitSet.of(requireDeterminism.toList().stream().filter(index -> index >= leftFieldCnt).map(index -> index - leftFieldCnt).collect(Collectors.toList()))) : ImmutableBitSet.range(rel.getRowType().getFieldCount())) : NO_REQUIRED_DETERMINISM;
        return this.transmitDeterminismRequirement(rel, inputRequireDeterminism);
    }

    private Map<Integer, List<Integer>> extractSourceMapping(List<RexNode> projects) {
        HashMap<Integer, List<Integer>> mapOutFromInPos = new HashMap<Integer, List<Integer>>();
        for (int index = 0; index < projects.size(); ++index) {
            RexNode expr = projects.get(index);
            mapOutFromInPos.put(index, FlinkRexUtil.findAllInputRefs(expr).stream().mapToInt(RexSlot::getIndex).boxed().collect(Collectors.toList()));
        }
        return mapOutFromInPos;
    }

    private void checkNonDeterministicRexProgram(ImmutableBitSet requireDeterminism, RexProgram program, StreamPhysicalRel relatedRel) {
        if (null != program.getCondition()) {
            RexNode rexNode = program.expandLocalRef(program.getCondition());
            this.checkNonDeterministicCondition(rexNode, relatedRel);
        }
        List projects = program.getProjectList().stream().map(program::expandLocalRef).collect(Collectors.toList());
        HashMap<Integer, String> nonDeterministicCols = new HashMap<Integer, String>();
        for (int index = 0; index < projects.size(); ++index) {
            Optional<String> ndCall = FlinkRexUtil.getNonDeterministicCallName((RexNode)projects.get(index));
            if (!ndCall.isPresent()) continue;
            nonDeterministicCols.put(index, ndCall.get());
        }
        List<Integer> unsatisfiedColumns = requireDeterminism.toList().stream().filter(nonDeterministicCols::containsKey).collect(Collectors.toList());
        if (!unsatisfiedColumns.isEmpty()) {
            this.throwNonDeterministicColumnsError(unsatisfiedColumns, relatedRel.getRowType(), relatedRel, nonDeterministicCols, Optional.empty());
        }
    }

    private void checkNonDeterministicCondition(RexNode condition, StreamPhysicalRel relatedRel) {
        Optional<String> ndCall = FlinkRexUtil.getNonDeterministicCallName(condition);
        ndCall.ifPresent(s2 -> this.throwNonDeterministicConditionError((String)s2, condition, relatedRel));
    }

    private void checkUnsatisfiedDeterminism(ImmutableBitSet requireDeterminism, int aggStartIndex, List<AggregateCall> aggCalls, RelDataType rowType, StreamPhysicalRel relatedRel) {
        HashMap<Integer, String> nonDeterministicOutput = new HashMap<Integer, String>();
        int aggOutputIndex = aggStartIndex;
        for (AggregateCall aggCall : aggCalls) {
            if (!aggCall.getAggregation().isDeterministic() || aggCall.getAggregation().isDynamicFunction()) {
                nonDeterministicOutput.put(aggOutputIndex, aggCall.getAggregation().getName());
            }
            ++aggOutputIndex;
        }
        List<Integer> unsatisfiedColumns = requireDeterminism.toList().stream().filter(nonDeterministicOutput::containsKey).collect(Collectors.toList());
        if (!unsatisfiedColumns.isEmpty()) {
            this.throwNonDeterministicColumnsError(unsatisfiedColumns, rowType, relatedRel, nonDeterministicOutput, Optional.empty());
        }
    }

    private void throwNonDeterministicConditionError(String ndCall, RexNode condition, StreamPhysicalRel relatedRel) throws TableException {
        String errorMsg = String.format(NON_DETERMINISTIC_CONDITION_ERROR_MSG_TEMPLATE, ndCall, condition) + "\nrelated rel plan:\n" + FlinkRelOptUtil.toString(relatedRel, SqlExplainLevel.DIGEST_ATTRIBUTES, false, true, false, true, false);
        throw new TableException(errorMsg);
    }

    private void throwNonDeterministicColumnsError(List<Integer> indexes, RelDataType rowType, StreamPhysicalRel relatedRel, Map<Integer, String> ndCallMap, Optional<String> ndCallName) throws TableException {
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("The column(s): ");
        int index = 0;
        for (String column : rowType.getFieldNames()) {
            if (indexes.contains(index)) {
                errorMsg.append(column).append("(generated by non-deterministic function: ");
                if (ndCallName.isPresent()) {
                    errorMsg.append(ndCallName.get());
                } else {
                    errorMsg.append(ndCallMap.get(index));
                }
                errorMsg.append(" ) ");
            }
            ++index;
        }
        errorMsg.append("can not satisfy the determinism requirement for correctly processing update message('UB'/'UA'/'D' in changelogMode, not 'I' only), this usually happens when input node has no upsertKey(upsertKeys=[{}]) or current node outputs non-deterministic update messages. Please consider removing these non-deterministic columns or making them deterministic by using deterministic functions.\n");
        errorMsg.append("\nrelated rel plan:\n").append(FlinkRelOptUtil.toString(relatedRel, SqlExplainLevel.DIGEST_ATTRIBUTES, false, true, false, true, false));
        throw new TableException(errorMsg.toString());
    }

    private ImmutableBitSet mappingRequireDeterminismToInput(ImmutableBitSet requireDeterminism, StreamPhysicalOverAggregateBase overAgg) {
        int inputFieldCnt = overAgg.getInput().getRowType().getFieldCount();
        List requireInputIndexes = requireDeterminism.toList().stream().filter(index -> index < inputFieldCnt).collect(Collectors.toList());
        if (requireInputIndexes.size() == inputFieldCnt) {
            return ImmutableBitSet.range(inputFieldCnt);
        }
        HashSet<Integer> allRequiredInputSet = new HashSet<Integer>(requireInputIndexes);
        OverSpec overSpec = OverAggregateUtil.createOverSpec(overAgg.logicWindow());
        Arrays.stream(overSpec.getPartition().getFieldIndices()).forEach(allRequiredInputSet::add);
        int aggOutputIndex = inputFieldCnt;
        for (OverSpec.GroupSpec groupSpec : overSpec.getGroups()) {
            for (AggregateCall aggCall : groupSpec.getAggCalls()) {
                if (requireDeterminism.get(aggOutputIndex)) {
                    this.requiredSourceInput(aggCall, allRequiredInputSet);
                }
                ++aggOutputIndex;
            }
        }
        assert (allRequiredInputSet.size() <= inputFieldCnt);
        return ImmutableBitSet.of(new ArrayList<Integer>(allRequiredInputSet));
    }

    private void requiredSourceInput(AggregateCall aggCall, Set<Integer> requiredInputSet) {
        requiredInputSet.addAll(aggCall.getArgList());
        if (aggCall.filterArg > -1) {
            requiredInputSet.add(aggCall.filterArg);
        }
    }

    private ImmutableBitSet requireDeterminismExcludeUpsertKey(StreamPhysicalRel inputRel, ImmutableBitSet requireDeterminism) {
        ImmutableBitSet finalRequireDeterminism;
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(inputRel.getCluster().getMetadataQuery());
        Set<ImmutableBitSet> inputUpsertKeys = fmq.getUpsertKeys(inputRel);
        if (inputUpsertKeys == null || inputUpsertKeys.isEmpty()) {
            finalRequireDeterminism = requireDeterminism;
        } else if (inputUpsertKeys.stream().anyMatch(uk -> uk.contains(requireDeterminism))) {
            finalRequireDeterminism = NO_REQUIRED_DETERMINISM;
        } else {
            List leftKeys = inputUpsertKeys.stream().map(requireDeterminism::except).collect(Collectors.toList());
            if (leftKeys.isEmpty()) {
                finalRequireDeterminism = NO_REQUIRED_DETERMINISM;
            } else {
                leftKeys.sort(Comparator.comparingInt(ImmutableBitSet::cardinality));
                finalRequireDeterminism = (ImmutableBitSet)leftKeys.get(0);
            }
        }
        return finalRequireDeterminism;
    }

    private static /* synthetic */ boolean lambda$visitLookupJoin$11(int leftFieldCnt, Integer index) {
        return index < leftFieldCnt;
    }

    private static /* synthetic */ boolean lambda$visitLookupJoin$10(StreamPhysicalLookupJoin lookupJoin, int index) {
        return lookupJoin.allLookupKeys().contains((Object)index);
    }

    private static /* synthetic */ boolean lambda$visitLookupJoin$9(int leftFieldCnt, Integer index) {
        return index >= leftFieldCnt;
    }

    private /* synthetic */ void lambda$visitLookupJoin$8(ImmutableBitSet requireDeterminism, StreamPhysicalLookupJoin lookupJoin, RexProgram calc) {
        this.checkNonDeterministicRexProgram(requireDeterminism, calc, lookupJoin);
    }

    private /* synthetic */ void lambda$visitLookupJoin$7(StreamPhysicalLookupJoin lookupJoin, RexNode cond) {
        this.checkNonDeterministicCondition(cond, lookupJoin);
    }

    private /* synthetic */ void lambda$visitLookupJoin$6(StreamPhysicalLookupJoin lookupJoin, RexNode cond) {
        this.checkNonDeterministicCondition(cond, lookupJoin);
    }
}

