/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.agg.batch.AggWithoutKeysCodeGenerator;
import org.apache.flink.table.planner.codegen.agg.batch.SortAggCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.InputSortedExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedOperator;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@ExecNodeMetadata(name="batch-exec-sort-aggregate", version=1, producedTransformations={"sort-aggregate"}, minPlanVersion=FlinkVersion.v2_0, minStateVersion=FlinkVersion.v2_0)
public class BatchExecSortAggregate
extends ExecNodeBase<RowData>
implements InputSortedExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String SORT_AGGREGATE_TRANSFORMATION = "sort-aggregate";
    public static final String FIELD_NAME_GROUPING = "grouping";
    public static final String FIELD_NAME_AUX_GROUPING = "auxGrouping";
    public static final String FIELD_NAME_AGG_CALLS = "aggCalls";
    public static final String FIELD_NAME_AGG_INPUT_ROW_TYPE = "aggInputRowType";
    public static final String FIELD_NAME_IS_MERGE = "isMerge";
    public static final String FIELD_NAME_IS_FINAL = "isFinal";
    @JsonProperty(value="grouping")
    private final int[] grouping;
    @JsonProperty(value="auxGrouping")
    private final int[] auxGrouping;
    @JsonProperty(value="aggCalls")
    private final AggregateCall[] aggCalls;
    @JsonProperty(value="aggInputRowType")
    private final RowType aggInputRowType;
    @JsonProperty(value="isMerge")
    private final boolean isMerge;
    @JsonProperty(value="isFinal")
    private final boolean isFinal;

    public BatchExecSortAggregate(ReadableConfig tableConfig, int[] grouping, int[] auxGrouping, AggregateCall[] aggCalls, RowType aggInputRowType, boolean isMerge, boolean isFinal, InputProperty inputProperty, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecSortAggregate.class), ExecNodeContext.newPersistedConfig(BatchExecSortAggregate.class, tableConfig), Collections.singletonList(inputProperty), (LogicalType)outputType, description);
        this.grouping = grouping;
        this.auxGrouping = auxGrouping;
        this.aggCalls = aggCalls;
        this.aggInputRowType = aggInputRowType;
        this.isMerge = isMerge;
        this.isFinal = isFinal;
    }

    @JsonCreator
    public BatchExecSortAggregate(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="grouping") int[] grouping, @JsonProperty(value="auxGrouping") int[] auxGrouping, @JsonProperty(value="aggCalls") AggregateCall[] aggCalls, @JsonProperty(value="aggInputRowType") RowType aggInputRowType, @JsonProperty(value="isMerge") boolean isMerge, @JsonProperty(value="isFinal") boolean isFinal, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        this.grouping = grouping;
        this.auxGrouping = auxGrouping;
        this.aggCalls = aggCalls;
        this.aggInputRowType = aggInputRowType;
        this.isMerge = isMerge;
        this.isFinal = isFinal;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        RowType outputRowType = (RowType)this.getOutputType();
        CodeGeneratorContext ctx = new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader());
        AggregateInfoList aggInfos = AggregateUtil.transformToBatchAggregateInfoList(planner.getTypeFactory(), this.aggInputRowType, JavaScalaConversionUtil.toScala(Arrays.asList(this.aggCalls)), null, null);
        GeneratedOperator<OneInputStreamOperator<RowData, RowData>> generatedOperator = this.grouping.length == 0 ? AggWithoutKeysCodeGenerator.genWithoutKeys(ctx, planner.createRelBuilder(), aggInfos, inputRowType, outputRowType, this.isMerge, this.isFinal, "NoGrouping") : SortAggCodeGenerator.genWithKeys(ctx, planner.createRelBuilder(), aggInfos, inputRowType, outputRowType, this.grouping, this.auxGrouping, this.isMerge, this.isFinal);
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(SORT_AGGREGATE_TRANSFORMATION, config), new CodeGenOperatorFactory(generatedOperator), InternalTypeInfo.of((RowType)outputRowType), inputTransform.getParallelism(), false);
    }
}

