/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlDropDatabase
extends SqlDrop {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("DROP DATABASE", SqlKind.OTHER_DDL);
    private final SqlIdentifier databaseName;
    private final boolean ifExists;
    private final boolean isCascade;

    public SqlDropDatabase(SqlParserPos pos, SqlIdentifier databaseName, boolean ifExists, boolean isCascade) {
        super(OPERATOR, pos, ifExists);
        this.databaseName = databaseName;
        this.ifExists = ifExists;
        this.isCascade = isCascade;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.databaseName);
    }

    public SqlIdentifier getDatabaseName() {
        return this.databaseName;
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    public boolean isCascade() {
        return this.isCascade;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP");
        writer.keyword("DATABASE");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.databaseName.unparse(writer, leftPrec, rightPrec);
        if (this.isCascade) {
            writer.keyword("CASCADE");
        } else {
            writer.keyword("RESTRICT");
        }
    }

    public String[] fullDatabaseName() {
        return this.databaseName.names.toArray(new String[0]);
    }
}

