/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.DataTypeExtractor;
import org.apache.flink.table.types.extraction.DataTypeTemplate;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.extraction.FunctionArgumentTemplate;
import org.apache.flink.table.types.extraction.FunctionResultTemplate;
import org.apache.flink.table.types.extraction.FunctionSignatureTemplate;
import org.apache.flink.table.types.extraction.FunctionTemplate;
import org.apache.flink.table.types.extraction.TemplateUtils;

abstract class BaseMappingExtractor {
    protected final DataTypeFactory typeFactory;
    private final String methodName;
    private final SignatureExtraction signatureExtraction;
    protected final ResultExtraction outputExtraction;
    protected final MethodVerification verification;

    public BaseMappingExtractor(DataTypeFactory typeFactory, String methodName, SignatureExtraction signatureExtraction, ResultExtraction outputExtraction, MethodVerification verification) {
        this.typeFactory = typeFactory;
        this.methodName = methodName;
        this.signatureExtraction = signatureExtraction;
        this.outputExtraction = outputExtraction;
        this.verification = verification;
    }

    protected abstract Set<FunctionTemplate> extractGlobalFunctionTemplates();

    protected abstract Set<FunctionTemplate> extractLocalFunctionTemplates(Method var1);

    protected abstract List<Method> collectMethods(String var1);

    protected abstract Class<?> getFunctionClass();

    protected abstract String getHintType();

    Map<FunctionSignatureTemplate, FunctionResultTemplate> extractOutputMapping() {
        try {
            return this.extractResultMappings(this.outputExtraction, FunctionTemplate::getOutputTemplate, this.verification);
        }
        catch (Throwable t) {
            throw ExtractionUtils.extractionError(t, "Error in extracting a signature to output mapping.", new Object[0]);
        }
    }

    protected Map<FunctionSignatureTemplate, FunctionResultTemplate> extractResultMappings(ResultExtraction resultExtraction, Function<FunctionTemplate, FunctionResultTemplate> accessor, MethodVerification verification) {
        Set<FunctionTemplate> global = this.extractGlobalFunctionTemplates();
        Set<FunctionResultTemplate> globalResultOnly = TemplateUtils.findResultOnlyTemplates(global, accessor);
        LinkedHashMap<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappings = new LinkedHashMap<FunctionSignatureTemplate, FunctionResultTemplate>();
        List<Method> methods = this.collectMethods(this.methodName);
        if (methods.size() == 0) {
            throw ExtractionUtils.extractionError("Could not find a publicly accessible method named '%s'.", this.methodName);
        }
        for (Method method : methods) {
            try {
                Method correctMethod = BaseMappingExtractor.correctVarArgMethod(method);
                Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappingsPerMethod = this.collectMethodMappings(correctMethod, global, globalResultOnly, resultExtraction, accessor);
                this.verifyMappingForMethod(correctMethod, collectedMappingsPerMethod, verification);
                this.verifyOptionalOnPrimitiveParameter(correctMethod, collectedMappingsPerMethod);
                collectedMappingsPerMethod.forEach((signature, result) -> this.putMapping((Map<FunctionSignatureTemplate, FunctionResultTemplate>)collectedMappings, (FunctionSignatureTemplate)signature, (FunctionResultTemplate)result));
            }
            catch (Throwable t) {
                throw ExtractionUtils.extractionError(t, "Unable to extract a type inference from method:\n%s", method.toString());
            }
        }
        return collectedMappings;
    }

    static Method correctVarArgMethod(Method method) {
        int paramCount = method.getParameterCount();
        Class<?>[] paramClasses = method.getParameterTypes();
        if (paramCount > 0 && paramClasses[paramCount - 1].getName().equals("scala.collection.Seq")) {
            Type[] paramTypes = method.getGenericParameterTypes();
            ParameterizedType seqType = (ParameterizedType)paramTypes[paramCount - 1];
            Type varArgType = seqType.getActualTypeArguments()[0];
            return ExtractionUtils.collectMethods(method.getDeclaringClass(), method.getName()).stream().filter(Method::isVarArgs).filter(candidate -> candidate.getParameterCount() == paramCount).filter(candidate -> {
                Type[] candidateParamTypes = candidate.getGenericParameterTypes();
                for (int i = 0; i < paramCount - 1; ++i) {
                    if (candidateParamTypes[i] == paramTypes[i]) continue;
                    return false;
                }
                Class<?> candidateVarArgType = candidate.getParameterTypes()[paramCount - 1];
                return candidateVarArgType.isArray() && (varArgType == Object.class || candidateVarArgType.getComponentType() == varArgType);
            }).findAny().orElse(method);
        }
        return method;
    }

    private Map<FunctionSignatureTemplate, FunctionResultTemplate> collectMethodMappings(Method method, Set<FunctionTemplate> global, Set<FunctionResultTemplate> globalResultOnly, ResultExtraction resultExtraction, Function<FunctionTemplate, FunctionResultTemplate> accessor) {
        LinkedHashMap<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappingsPerMethod = new LinkedHashMap<FunctionSignatureTemplate, FunctionResultTemplate>();
        Set<FunctionTemplate> local = this.extractLocalFunctionTemplates(method);
        Set<FunctionResultTemplate> localResultOnly = TemplateUtils.findResultOnlyTemplates(local, accessor);
        Set<FunctionTemplate> explicitMappings = TemplateUtils.findResultMappingTemplates(global, local, accessor);
        FunctionResultTemplate resultOnly = TemplateUtils.findResultOnlyTemplate(globalResultOnly, localResultOnly, explicitMappings, accessor, this.getHintType());
        Set<FunctionSignatureTemplate> inputOnly = TemplateUtils.findInputOnlyTemplates(global, local, accessor);
        this.putExplicitMappings(collectedMappingsPerMethod, explicitMappings, inputOnly, accessor);
        this.putUniqueResultMappings(collectedMappingsPerMethod, resultOnly, inputOnly, method);
        this.putExtractedResultMappings(collectedMappingsPerMethod, inputOnly, resultExtraction, method);
        return collectedMappingsPerMethod;
    }

    private void putExplicitMappings(Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappings, Set<FunctionTemplate> explicitMappings, Set<FunctionSignatureTemplate> signatureOnly, Function<FunctionTemplate, FunctionResultTemplate> accessor) {
        explicitMappings.forEach(t -> Stream.concat(signatureOnly.stream(), Stream.of(t.getSignatureTemplate())).forEach(v -> this.putMapping(collectedMappings, (FunctionSignatureTemplate)v, (FunctionResultTemplate)accessor.apply((FunctionTemplate)t))));
    }

    private void putUniqueResultMappings(Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappings, @Nullable FunctionResultTemplate uniqueResult, Set<FunctionSignatureTemplate> signatureOnly, Method method) {
        if (uniqueResult == null) {
            return;
        }
        if (!signatureOnly.isEmpty()) {
            signatureOnly.forEach(s -> this.putMapping(collectedMappings, (FunctionSignatureTemplate)s, uniqueResult));
        } else {
            this.putMapping(collectedMappings, this.signatureExtraction.extract(this, method), uniqueResult);
        }
    }

    private void putExtractedResultMappings(Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappings, Set<FunctionSignatureTemplate> inputOnly, ResultExtraction resultExtraction, Method method) {
        if (!collectedMappings.isEmpty()) {
            return;
        }
        FunctionResultTemplate result = resultExtraction.extract(this, method);
        if (!inputOnly.isEmpty()) {
            inputOnly.forEach(signature -> this.putMapping(collectedMappings, (FunctionSignatureTemplate)signature, result));
        } else {
            FunctionSignatureTemplate signature2 = this.signatureExtraction.extract(this, method);
            this.putMapping(collectedMappings, signature2, result);
        }
    }

    private void putMapping(Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappings, FunctionSignatureTemplate signature, FunctionResultTemplate result) {
        FunctionResultTemplate existingResult = collectedMappings.get(signature);
        if (existingResult == null) {
            collectedMappings.put(signature, result);
        } else if (!existingResult.equals(result)) {
            throw ExtractionUtils.extractionError(String.format("%s hints with same input definition but different result types are not allowed.", this.getHintType()), new Object[0]);
        }
    }

    private void verifyMappingForMethod(Method method, Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappingsPerMethod, MethodVerification verification) {
        collectedMappingsPerMethod.forEach((signature, result) -> verification.verify(method, signature.toClass(), result.toClass()));
    }

    private void verifyOptionalOnPrimitiveParameter(Method method, Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappingsPerMethod) {
        collectedMappingsPerMethod.keySet().forEach(signature -> {
            Boolean[] argumentOptional = signature.argumentOptionals;
            if (argumentOptional != null && Arrays.stream(argumentOptional).anyMatch(Boolean::booleanValue)) {
                FunctionSignatureTemplate functionResultTemplate = this.signatureExtraction.extract(this, method);
                for (int i = 0; i < argumentOptional.length; ++i) {
                    DataType dataType = functionResultTemplate.argumentTemplates.get((int)i).dataType;
                    if (dataType == null || !argumentOptional[i].booleanValue() || dataType.getConversionClass() == null || !dataType.getConversionClass().isPrimitive()) continue;
                    throw ExtractionUtils.extractionError("Argument at position %d is optional but a primitive type doesn't accept null value.", i);
                }
            }
        });
    }

    static SignatureExtraction createParameterSignatureExtraction(int offset) {
        return (extractor, method) -> {
            List<FunctionArgumentTemplate> parameterTypes = BaseMappingExtractor.extractArgumentTemplates(extractor.typeFactory, extractor.getFunctionClass(), method, offset);
            String[] argumentNames = BaseMappingExtractor.extractArgumentNames(method, offset);
            Boolean[] argumentOptionals = BaseMappingExtractor.extractArgumentOptionals(method, offset);
            return FunctionSignatureTemplate.of(parameterTypes, method.isVarArgs(), argumentNames, argumentOptionals);
        };
    }

    private static List<FunctionArgumentTemplate> extractArgumentTemplates(DataTypeFactory typeFactory, Class<?> extractedClass, Method method, int offset) {
        return IntStream.range(offset, method.getParameterCount()).mapToObj(i -> BaseMappingExtractor.tryExtractInputGroupArgument(method, i).orElseGet(() -> BaseMappingExtractor.extractDataTypeArgument(typeFactory, extractedClass, method, i))).collect(Collectors.toList());
    }

    static Optional<FunctionArgumentTemplate> tryExtractInputGroupArgument(Method method, int paramPos) {
        Parameter parameter = method.getParameters()[paramPos];
        DataTypeHint hint = parameter.getAnnotation(DataTypeHint.class);
        ArgumentHint argumentHint = parameter.getAnnotation(ArgumentHint.class);
        if (hint != null && argumentHint != null) {
            throw ExtractionUtils.extractionError("Argument and dataType hints cannot be declared in the same parameter at position %d.", paramPos);
        }
        if (argumentHint != null) {
            DataTypeTemplate template = DataTypeTemplate.fromAnnotation(argumentHint, null);
            if (template.inputGroup != null) {
                return Optional.of(FunctionArgumentTemplate.of(template.inputGroup));
            }
        } else if (hint != null) {
            DataTypeTemplate template = DataTypeTemplate.fromAnnotation(hint, null);
            if (template.inputGroup != null) {
                return Optional.of(FunctionArgumentTemplate.of(template.inputGroup));
            }
        }
        return Optional.empty();
    }

    private static FunctionArgumentTemplate extractDataTypeArgument(DataTypeFactory typeFactory, Class<?> extractedClass, Method method, int paramPos) {
        DataType type = DataTypeExtractor.extractFromMethodParameter(typeFactory, extractedClass, method, paramPos);
        if (method.isVarArgs() && paramPos == method.getParameterCount() - 1) {
            if (type instanceof CollectionDataType) {
                return FunctionArgumentTemplate.of(((CollectionDataType)type).getElementDataType());
            }
            if (type.equals(DataTypes.BYTES())) {
                return FunctionArgumentTemplate.of((DataType)((DataType)DataTypes.TINYINT().notNull()).bridgedTo(Byte.TYPE));
            }
        }
        return FunctionArgumentTemplate.of(type);
    }

    @Nullable
    static String[] extractArgumentNames(Method method, int offset) {
        List<String> methodParameterNames = ExtractionUtils.extractMethodParameterNames(method);
        if (methodParameterNames != null) {
            return methodParameterNames.subList(offset, methodParameterNames.size()).toArray(new String[0]);
        }
        return null;
    }

    static Boolean[] extractArgumentOptionals(Method method, int offset) {
        return (Boolean[])Arrays.stream(method.getParameters()).skip(offset).map(parameter -> parameter.getAnnotation(ArgumentHint.class)).map(argumentHint -> argumentHint != null && argumentHint.isOptional()).toArray(Boolean[]::new);
    }

    protected static ValidationException createMethodNotFoundError(String methodName, Class<?>[] parameters, @Nullable Class<?> returnType) {
        return ExtractionUtils.extractionError("Considering all hints, the method should comply with the signature:\n%s", ExtractionUtils.createMethodSignatureString(methodName, parameters, returnType));
    }

    protected static interface MethodVerification {
        public void verify(Method var1, List<Class<?>> var2, Class<?> var3);
    }

    protected static interface ResultExtraction {
        @Nullable
        public FunctionResultTemplate extract(BaseMappingExtractor var1, Method var2);
    }

    protected static interface SignatureExtraction {
        public FunctionSignatureTemplate extract(BaseMappingExtractor var1, Method var2);
    }
}

