/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window.value;

import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.segment.column.ColumnType;

public abstract class ShiftedColumnAccessorBase
implements ColumnAccessor {
    private final ColumnAccessor accessor;

    public ShiftedColumnAccessorBase(ColumnAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public ColumnType getType() {
        return this.accessor.getType();
    }

    @Override
    public int numRows() {
        return this.accessor.numRows();
    }

    @Override
    public boolean isNull(int rowNum) {
        int actualCell = this.getActualValue(rowNum);
        if (this.outsideBounds(actualCell)) {
            return true;
        }
        return this.accessor.isNull(actualCell);
    }

    @Override
    public Object getObject(int rowNum) {
        int actualCell = this.getActualValue(rowNum);
        if (this.outsideBounds(actualCell)) {
            return null;
        }
        return this.accessor.getObject(actualCell);
    }

    @Override
    public double getDouble(int rowNum) {
        int actualCell = this.getActualValue(rowNum);
        if (this.outsideBounds(actualCell)) {
            return 0.0;
        }
        return this.accessor.getDouble(actualCell);
    }

    @Override
    public float getFloat(int rowNum) {
        int actualCell = this.getActualValue(rowNum);
        if (this.outsideBounds(actualCell)) {
            return 0.0f;
        }
        return this.accessor.getFloat(actualCell);
    }

    @Override
    public long getLong(int rowNum) {
        int actualCell = this.getActualValue(rowNum);
        if (this.outsideBounds(actualCell)) {
            return 0L;
        }
        return this.accessor.getLong(actualCell);
    }

    @Override
    public int getInt(int rowNum) {
        int actualCell = this.getActualValue(rowNum);
        if (this.outsideBounds(actualCell)) {
            return 0;
        }
        return this.accessor.getInt(actualCell);
    }

    @Override
    public int compareRows(int lhsRowNum, int rhsRowNum) {
        int actualLhsCell = this.getActualValue(lhsRowNum);
        int actualRhsCell = this.getActualValue(rhsRowNum);
        if (this.outsideBounds(actualLhsCell)) {
            if (this.outsideBounds(actualRhsCell)) {
                return 0;
            }
            return this.accessor.isNull(actualRhsCell) ? 0 : -1;
        }
        if (this.outsideBounds(actualRhsCell)) {
            return this.accessor.isNull(actualLhsCell) ? 0 : 1;
        }
        return this.accessor.compareRows(actualLhsCell, actualRhsCell);
    }

    protected abstract int getActualValue(int var1);

    protected abstract boolean outsideBounds(int var1);
}

