/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.groupby.epinephelinae.AggregateResult;

public class Groupers {
    private static final AggregateResult DICTIONARY_FULL_ZERO_COUNT = AggregateResult.partial(0, "Not enough dictionary memory to execute this query. Try enabling disk spilling by setting druid.query.groupBy.maxOnDiskStorage to an amount of bytes available on your machine for on-disk scratch files. See https://druid.apache.org/docs/latest/querying/groupbyquery.html#memory-tuning-and-resource-limits for details.");
    private static final AggregateResult HASH_TABLE_FULL_ZERO_COUNT = AggregateResult.partial(0, "Not enough merge buffer memory to execute this query. Try enabling disk spilling by setting druid.query.groupBy.maxOnDiskStorage to an amount of bytes available on your machine for on-disk scratch files. Or, if you have additional off-heap memory available, consider increasing druid.processing.buffer.sizeBytes. See https://druid.apache.org/docs/latest/querying/groupbyquery.html#memory-tuning-and-resource-limits for details.");
    private static final int USED_FLAG_MASK = Integer.MAX_VALUE;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;

    private Groupers() {
    }

    public static int smear(int hashCode) {
        return 461845907 * Integer.rotateLeft(hashCode * -862048943, 15);
    }

    public static AggregateResult dictionaryFull(int count) {
        if (count == 0) {
            return DICTIONARY_FULL_ZERO_COUNT;
        }
        return AggregateResult.partial(count, DICTIONARY_FULL_ZERO_COUNT.getReason());
    }

    public static AggregateResult hashTableFull(int count) {
        if (count == 0) {
            return HASH_TABLE_FULL_ZERO_COUNT;
        }
        return AggregateResult.partial(count, HASH_TABLE_FULL_ZERO_COUNT.getReason());
    }

    public static int hashObject(Object obj) {
        return Groupers.smear(obj.hashCode()) & Integer.MAX_VALUE;
    }

    static int getUsedFlag(int keyHash) {
        return keyHash | Integer.MIN_VALUE;
    }

    public static ByteBuffer getSlice(ByteBuffer buffer, int sliceSize, int i) {
        ByteBuffer slice = buffer.duplicate();
        slice.position(sliceSize * i);
        slice.limit(slice.position() + sliceSize);
        return slice.slice();
    }

    @Nullable
    public static int[] writeAggregationRows(int[] scratch, int start, int end) {
        if (start == 0) {
            return null;
        }
        int numRows = end - start;
        for (int i = 0; i < numRows; ++i) {
            scratch[i] = start + i;
        }
        return scratch;
    }
}

