/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import inet.ipaddr.ipv4.IPv4Address;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.expression.IPv4AddressExprUtils;

public class IPv4AddressStringifyExprMacro
implements ExprMacroTable.ExprMacro {
    public static final String FN_NAME = "ipv4_stringify";

    @Override
    public String name() {
        return FN_NAME;
    }

    @Override
    public Expr apply(List<Expr> args) {
        this.validationHelperCheckArgumentCount(args, 1);
        final Expr arg = args.get(0);
        class IPv4AddressStringifyExpr
        extends ExprMacroTable.BaseScalarMacroFunctionExpr {
            private IPv4AddressStringifyExpr(List<Expr> args) {
                super(this$0, args);
            }

            @Override
            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                ExprEval eval = arg.eval(bindings);
                switch ((ExprType)eval.type().getType()) {
                    case STRING: {
                        return IPv4AddressStringifyExprMacro.evalAsString(eval);
                    }
                    case LONG: {
                        return IPv4AddressStringifyExprMacro.evalAsLong(eval);
                    }
                }
                return ExprEval.ofString(null);
            }

            @Override
            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return ExpressionType.STRING;
            }
        }
        return new IPv4AddressStringifyExpr(args);
    }

    private static ExprEval evalAsString(ExprEval eval) {
        if (IPv4AddressExprUtils.isValidIPv4Address(eval.asString())) {
            return eval;
        }
        return ExprEval.ofString(null);
    }

    private static ExprEval evalAsLong(ExprEval eval) {
        if (eval.isNumericNull()) {
            return ExprEval.ofString(null);
        }
        IPv4Address address = IPv4AddressExprUtils.parse(eval.asLong());
        if (address == null) {
            return ExprEval.ofString(null);
        }
        return ExprEval.ofString(IPv4AddressExprUtils.toString(address));
    }
}

