/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.druid.catalog.model.ObjectFacade;
import org.apache.druid.catalog.model.TableDefn;
import org.apache.druid.catalog.model.TableSpec;

public class ResolvedTable
extends ObjectFacade {
    private final TableDefn defn;
    private final TableSpec spec;
    private final ObjectMapper jsonMapper;

    public ResolvedTable(TableDefn defn, TableSpec spec, ObjectMapper jsonMapper) {
        this.defn = defn;
        this.spec = spec;
        this.jsonMapper = jsonMapper;
    }

    public TableDefn defn() {
        return this.defn;
    }

    public TableSpec spec() {
        return this.spec;
    }

    public ResolvedTable merge(TableSpec update) {
        return new ResolvedTable(this.defn, this.defn.merge(this.spec, update, this.jsonMapper), this.jsonMapper);
    }

    public ResolvedTable withProperties(Map<String, Object> props) {
        return new ResolvedTable(this.defn, this.spec.withProperties(props), this.jsonMapper);
    }

    public void validate() {
        this.spec.validate();
        this.defn.validate(this);
    }

    @Override
    public Map<String, Object> properties() {
        return this.spec.properties();
    }

    public <T> T decodeProperty(String key) {
        Object value = this.spec.properties().get(key);
        if (value == null) {
            return null;
        }
        return (T)this.defn.property(key).decode(value, this.jsonMapper);
    }

    public ObjectMapper jsonMapper() {
        return this.jsonMapper;
    }
}

