/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.msq.dart.controller.ControllerHolder;

public class DartControllerRegistry {
    private final ConcurrentHashMap<String, ControllerHolder> controllerMap = new ConcurrentHashMap();

    public void register(ControllerHolder holder) {
        if (this.controllerMap.putIfAbsent(holder.getController().queryId(), holder) != null) {
            throw DruidException.defensive((String)"Controller[%s] already registered", (Object[])new Object[]{holder.getController().queryId()});
        }
    }

    public void deregister(ControllerHolder holder) {
        this.controllerMap.remove(holder.getController().queryId(), holder);
    }

    @Nullable
    public ControllerHolder get(String queryId) {
        return this.controllerMap.get(queryId);
    }

    public Collection<ControllerHolder> getAllHolders() {
        return this.controllerMap.values();
    }
}

