/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.azure.core.http.rest.PagedIterable;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.batch.BlobBatchClient;
import com.azure.storage.blob.batch.BlobBatchStorageException;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.options.BlobInputStreamOptions;
import com.azure.storage.blob.options.BlockBlobOutputStreamOptions;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.azure.AzureClientFactory;

public class AzureStorage {
    private static final int DELTA_BACKOFF_MS = 30000;
    private static final Integer MAX_MULTI_OBJECT_DELETE_SIZE = 256;
    private static final Logger LOG = new Logger(AzureStorage.class);
    private final AzureClientFactory azureClientFactory;
    private final String defaultStorageAccount;

    public AzureStorage(AzureClientFactory azureClientFactory, String defaultStorageAccount) {
        this.azureClientFactory = azureClientFactory;
        this.defaultStorageAccount = defaultStorageAccount;
    }

    public List<String> emptyCloudBlobDirectory(String containerName, @Nullable String prefix) throws BlobStorageException {
        return this.emptyCloudBlobDirectory(containerName, prefix, null);
    }

    public List<String> emptyCloudBlobDirectory(String containerName, @Nullable String prefix, @Nullable Integer maxAttempts) throws BlobStorageException {
        BlobContainerClient blobContainerClient = this.azureClientFactory.getBlobServiceClient(maxAttempts, this.defaultStorageAccount).getBlobContainerClient(containerName);
        PagedIterable blobItems = blobContainerClient.listBlobs(new ListBlobsOptions().setPrefix(prefix), Duration.ofMillis(30000L));
        ArrayList<String> deletedFiles = new ArrayList<String>();
        blobItems.iterableByPage().forEach(page -> page.getElements().forEach(blob -> {
            if (blobContainerClient.getBlobClient(blob.getName()).deleteIfExists()) {
                deletedFiles.add(blob.getName());
            }
        }));
        if (deletedFiles.isEmpty()) {
            LOG.warn("No files were deleted on the following Azure path: [%s]", new Object[]{prefix});
        }
        return deletedFiles;
    }

    public OutputStream getBlockBlobOutputStream(String containerName, String blobName, @Nullable Long blockSize, @Nullable Integer maxAttempts) throws BlobStorageException {
        BlockBlobClient blockBlobClient = this.azureClientFactory.getBlobServiceClient(maxAttempts, this.defaultStorageAccount).createBlobContainerIfNotExists(containerName).getBlobClient(blobName).getBlockBlobClient();
        if (blockBlobClient.exists().booleanValue()) {
            throw new RE("Reference already exists", new Object[0]);
        }
        BlockBlobOutputStreamOptions options = new BlockBlobOutputStreamOptions();
        if (blockSize != null) {
            options.setParallelTransferOptions(new ParallelTransferOptions().setBlockSizeLong(blockSize));
        }
        return blockBlobClient.getBlobOutputStream(options);
    }

    public long getBlockBlobLength(String containerName, String blobName) throws BlobStorageException {
        return this.azureClientFactory.getBlobServiceClient(null, this.defaultStorageAccount).getBlobContainerClient(containerName).getBlobClient(blobName).getBlockBlobClient().getProperties().getBlobSize();
    }

    public InputStream getBlockBlobInputStream(String containerName, String blobName) throws BlobStorageException {
        return this.getBlockBlobInputStream(0L, containerName, blobName);
    }

    public InputStream getBlockBlobInputStream(long offset, String containerName, String blobName) throws BlobStorageException {
        return this.getBlockBlobInputStream(offset, null, containerName, blobName);
    }

    public InputStream getBlockBlobInputStream(long offset, @Nullable Long length, String containerName, String blobName) throws BlobStorageException {
        return this.getBlockBlobInputStream(offset, length, containerName, blobName, null);
    }

    public InputStream getBlockBlobInputStream(long offset, @Nullable Long length, String containerName, String blobName, @Nullable Integer maxAttempts) throws BlobStorageException {
        return this.azureClientFactory.getBlobServiceClient(maxAttempts, this.defaultStorageAccount).getBlobContainerClient(containerName).getBlobClient(blobName).openInputStream(new BlobInputStreamOptions().setRange(new BlobRange(offset, length)));
    }

    public boolean batchDeleteFiles(String containerName, Iterable<String> paths, @Nullable Integer maxAttempts) throws BlobBatchStorageException {
        BlobContainerClient blobContainerClient = this.azureClientFactory.getBlobServiceClient(maxAttempts, this.defaultStorageAccount).getBlobContainerClient(containerName);
        BlobBatchClient blobBatchClient = this.azureClientFactory.getBlobBatchClient(blobContainerClient);
        List blobUris = Streams.stream(paths).map(path -> blobContainerClient.getBlobContainerUrl() + "/" + path).collect(Collectors.toList());
        boolean hadException = false;
        List keysChunks = Lists.partition(blobUris, (int)MAX_MULTI_OBJECT_DELETE_SIZE);
        for (List chunkOfKeys : keysChunks) {
            try {
                LOG.info("Removing from container [%s] the following files: [%s]", new Object[]{containerName, chunkOfKeys});
                blobBatchClient.deleteBlobs(chunkOfKeys, DeleteSnapshotsOptionType.INCLUDE).forEach(response -> LOG.debug("Deleting blob with URL %s completed with status code %d%n", new Object[]{response.getRequest().getUrl(), response.getStatusCode()}));
            }
            catch (BlobBatchStorageException | BlobStorageException e) {
                hadException = true;
                LOG.noStackTrace().warn(e, "Unable to delete from container [%s], the following keys [%s]", new Object[]{containerName, chunkOfKeys});
            }
            catch (Exception e) {
                hadException = true;
                LOG.noStackTrace().warn((Throwable)e, "Unexpected exception occurred when deleting from container [%s], the following keys [%s]", new Object[]{containerName, chunkOfKeys});
            }
        }
        return !hadException;
    }

    public boolean getBlockBlobExists(String container, String blobName) throws BlobStorageException {
        return this.getBlockBlobExists(container, blobName, null);
    }

    public boolean getBlockBlobExists(String container, String blobName, @Nullable Integer maxAttempts) throws BlobStorageException {
        return this.azureClientFactory.getBlobServiceClient(maxAttempts, this.defaultStorageAccount).getBlobContainerClient(container).getBlobClient(blobName).exists();
    }

    public PagedIterable<BlobItem> listBlobsWithPrefixInContainerSegmented(String storageAccount, String containerName, @Nullable String prefix, @Nullable Integer maxResults, @Nullable Integer maxAttempts) throws BlobStorageException {
        ListBlobsOptions listOptions = new ListBlobsOptions();
        if (maxResults != null) {
            listOptions.setMaxResultsPerPage(maxResults);
        }
        if (prefix != null) {
            listOptions.setPrefix(prefix);
        }
        return this.azureClientFactory.getBlobServiceClient(maxAttempts, storageAccount).getBlobContainerClient(containerName).listBlobs(listOptions, Duration.ofMillis(30000L));
    }

    public List<String> listBlobs(String containerName, @Nullable String prefix, @Nullable Integer maxResults, @Nullable Integer maxAttempts) throws BlobStorageException {
        ListBlobsOptions listOptions = new ListBlobsOptions().setPrefix(prefix);
        if (maxResults != null) {
            listOptions.setMaxResultsPerPage(maxResults);
        }
        if (prefix != null) {
            listOptions.setPrefix(prefix);
        }
        PagedIterable blobItems = this.azureClientFactory.getBlobServiceClient(maxAttempts, this.defaultStorageAccount).getBlobContainerClient(containerName).listBlobs(listOptions, Duration.ofMillis(30000L));
        ArrayList<String> files = new ArrayList<String>();
        blobItems.iterableByPage().forEach(page -> page.getElements().forEach(blob -> files.add(blob.getName())));
        return files;
    }

    public void uploadBlockBlob(File file, String containerName, String blobName, @Nullable Integer maxAttempts) throws IOException, BlobStorageException {
        BlobContainerClient blobContainerClient = this.azureClientFactory.getBlobServiceClient(maxAttempts, this.defaultStorageAccount).createBlobContainerIfNotExists(containerName);
        try (FileInputStream stream = new FileInputStream(file);){
            blobContainerClient.getBlobClient(blobName).upload((InputStream)stream, file.length(), true);
        }
    }
}

