/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.policy.ExponentialBackoffOptions;
import com.azure.core.http.policy.RetryOptions;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.batch.BlobBatchClient;
import com.azure.storage.blob.batch.BlobBatchClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.storage.azure.AzureAccountConfig;

public class AzureClientFactory {
    protected final AzureAccountConfig config;
    private final Map<Pair<String, Integer>, BlobServiceClient> cachedBlobServiceClients;

    public AzureClientFactory(AzureAccountConfig config) {
        this.config = config;
        this.cachedBlobServiceClients = new ConcurrentHashMap<Pair<String, Integer>, BlobServiceClient>();
    }

    public BlobServiceClient getBlobServiceClient(@Nullable Integer retryCount, String storageAccount) {
        return this.cachedBlobServiceClients.computeIfAbsent((Pair<String, Integer>)Pair.of((Object)storageAccount, (Object)(retryCount != null ? retryCount.intValue() : this.config.getMaxTries())), key -> this.buildNewClient((Integer)key.rhs, (String)key.lhs));
    }

    public BlobBatchClient getBlobBatchClient(BlobContainerClient blobContainerClient) {
        return new BlobBatchClientBuilder(blobContainerClient).buildClient();
    }

    protected BlobServiceClient buildNewClient(Integer retryCount, String storageAccount) {
        BlobServiceClientBuilder clientBuilder = new BlobServiceClientBuilder().endpoint("https://" + storageAccount + "." + this.config.getBlobStorageEndpoint());
        if (this.config.getKey() != null) {
            clientBuilder.credential(new StorageSharedKeyCredential(storageAccount, this.config.getKey()));
        } else if (this.config.getSharedAccessStorageToken() != null) {
            clientBuilder.sasToken(this.config.getSharedAccessStorageToken());
        } else if (this.config.getUseAzureCredentialsChain().booleanValue()) {
            DefaultAzureCredentialBuilder defaultAzureCredentialBuilder = new DefaultAzureCredentialBuilder().managedIdentityClientId(this.config.getManagedIdentityClientId());
            clientBuilder.credential((TokenCredential)defaultAzureCredentialBuilder.build());
        }
        return clientBuilder.retryOptions(new RetryOptions(new ExponentialBackoffOptions().setMaxRetries(retryCount).setBaseDelay(Duration.ofMillis(1000L)).setMaxDelay(Duration.ofMillis(60000L)))).buildClient();
    }
}

