/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;

public class AzureAccountConfig {
    @JsonProperty
    @Nullable
    private String account;
    @Deprecated
    @Nullable
    @JsonProperty
    private String endpointSuffix = null;
    @JsonProperty
    private String key;
    @JsonProperty
    private String managedIdentityClientId;
    @JsonProperty
    @Min(value=1L)
    private @Min(value=1L) int maxTries = 3;
    @JsonProperty
    private String protocol = "https";
    @JsonProperty
    private String sharedAccessStorageToken;
    @JsonProperty
    private String storageAccountEndpointSuffix = "blob.core.windows.net";
    @JsonProperty
    private boolean useAzureCredentialsChain = false;

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    @Nullable
    @Deprecated
    public String getEndpointSuffix() {
        return this.endpointSuffix;
    }

    public void setEndpointSuffix(String endpointSuffix) {
        this.endpointSuffix = endpointSuffix;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getManagedIdentityClientId() {
        return this.managedIdentityClientId;
    }

    public void setManagedIdentityClientId(String managedIdentityClientId) {
        this.managedIdentityClientId = managedIdentityClientId;
    }

    public int getMaxTries() {
        return this.maxTries;
    }

    public void setMaxTries(int maxTries) {
        this.maxTries = maxTries;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getSharedAccessStorageToken() {
        return this.sharedAccessStorageToken;
    }

    public void setSharedAccessStorageToken(String sharedAccessStorageToken) {
        this.sharedAccessStorageToken = sharedAccessStorageToken;
    }

    public String getStorageAccountEndpointSuffix() {
        return this.storageAccountEndpointSuffix;
    }

    public void setStorageAccountEndpointSuffix(String storageAccountEndpointSuffix) {
        this.storageAccountEndpointSuffix = storageAccountEndpointSuffix;
    }

    public Boolean getUseAzureCredentialsChain() {
        return this.useAzureCredentialsChain;
    }

    public void setUseAzureCredentialsChain(Boolean useAzureCredentialsChain) {
        this.useAzureCredentialsChain = useAzureCredentialsChain;
    }

    public String getBlobStorageEndpoint() {
        if (this.endpointSuffix != null) {
            return "blob." + this.endpointSuffix;
        }
        return this.storageAccountEndpointSuffix;
    }
}

