/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo;

public final class SchemaEntry {
    private final String id;
    private final String schema;

    public SchemaEntry(String id, String schema) {
        this.id = id;
        this.schema = schema;
    }

    public SchemaEntry(String stringForm) {
        int tab = stringForm.indexOf(9);
        if (tab < 1) {
            throw new IllegalArgumentException("Invalid Schema Entry Serialization: " + stringForm);
        }
        this.id = stringForm.substring(0, tab);
        this.schema = stringForm.substring(tab + 1);
    }

    public String getId() {
        return this.id;
    }

    public String getSchema() {
        return this.schema;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.id == null ? 0 : this.id.hashCode();
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaEntry other = (SchemaEntry)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.schema == null ? other.schema != null : !this.schema.equals(other.schema));
    }

    public String toString() {
        return this.id + "\t" + this.schema;
    }
}

