/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.pac4j;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.EnumSet;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.druid.security.pac4j.JwtAuthFilter;
import org.apache.druid.security.pac4j.OIDCConfig;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authenticator;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.profile.creator.TokenValidator;

@JsonTypeName(value="jwt")
public class JwtAuthenticator
implements Authenticator {
    private final String authorizerName;
    private final OIDCConfig oidcConfig;
    private final Supplier<TokenValidator> tokenValidatorSupplier;
    private final String name;

    @JsonCreator
    public JwtAuthenticator(@JsonProperty(value="name") String name, @JsonProperty(value="authorizerName") String authorizerName, @JacksonInject OIDCConfig oidcConfig) {
        this.name = name;
        this.oidcConfig = oidcConfig;
        this.authorizerName = authorizerName;
        this.tokenValidatorSupplier = Suppliers.memoize(() -> this.createTokenValidator(oidcConfig));
    }

    public Filter getFilter() {
        return new JwtAuthFilter(this.authorizerName, this.name, this.oidcConfig, (TokenValidator)this.tokenValidatorSupplier.get());
    }

    public Class<? extends Filter> getFilterClass() {
        return JwtAuthFilter.class;
    }

    public Map<String, String> getInitParameters() {
        return null;
    }

    public String getPath() {
        return "/*";
    }

    @Nullable
    public EnumSet<DispatcherType> getDispatcherType() {
        return null;
    }

    @Nullable
    public String getAuthChallengeHeader() {
        return null;
    }

    @Nullable
    public AuthenticationResult authenticateJDBCContext(Map<String, Object> context) {
        return null;
    }

    private TokenValidator createTokenValidator(OIDCConfig config) {
        OidcConfiguration oidcConfiguration = new OidcConfiguration();
        oidcConfiguration.setClientId(config.getClientID());
        oidcConfiguration.setSecret(config.getClientSecret().getPassword());
        oidcConfiguration.setDiscoveryURI(config.getDiscoveryURI());
        return new TokenValidator(oidcConfiguration);
    }
}

