/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.ThetaSketch;

final class MemorySegmentHashIterator
implements HashIterator {
    private MemorySegment seg;
    private int arrLongs;
    private long thetaLong;
    private long offsetBytes;
    private int index;
    private long hash;

    MemorySegmentHashIterator(MemorySegment srcSeg, int arrLongs, long thetaLong) {
        this.seg = srcSeg;
        this.arrLongs = arrLongs;
        this.thetaLong = thetaLong;
        this.offsetBytes = ThetaSketch.getPreambleLongs(srcSeg) << 3;
        this.index = -1;
        this.hash = 0L;
    }

    @Override
    public long get() {
        return this.hash;
    }

    @Override
    public boolean next() {
        while (++this.index < this.arrLongs) {
            this.hash = this.seg.get(ValueLayout.JAVA_LONG_UNALIGNED, this.offsetBytes + (long)(this.index << 3));
            if (this.hash == 0L || this.hash >= this.thetaLong) continue;
            return true;
        }
        return false;
    }
}

