/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.common;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Objects;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.Util;

public class ArrayOfDoublesSerDe
extends ArrayOfItemsSerDe<Double> {
    @Override
    public byte[] serializeToByteArray(Double item) {
        Objects.requireNonNull(item, "Item must not be null");
        byte[] byteArr = new byte[8];
        ByteArrayUtil.putDoubleLE(byteArr, 0, item);
        return byteArr;
    }

    @Override
    public byte[] serializeToByteArray(Double[] items) {
        Objects.requireNonNull(items, "Items must not be null");
        if (items.length == 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[8 * items.length];
        MemorySegment seg = MemorySegment.ofArray(bytes);
        long offset = 0L;
        for (int i = 0; i < items.length; ++i) {
            seg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, offset, items[i]);
            offset += 8L;
        }
        return bytes;
    }

    public Double[] deserializeFromMemorySegment(MemorySegment seg, int numItems) {
        return this.deserializeFromMemorySegment(seg, 0L, numItems);
    }

    public Double[] deserializeFromMemorySegment(MemorySegment seg, long offsetBytes, int numItems) {
        Objects.requireNonNull(seg, "MemorySegment must not be null");
        if (numItems <= 0) {
            return new Double[0];
        }
        long offset = offsetBytes;
        Util.checkBounds(offset, 8L * (long)numItems, seg.byteSize());
        Double[] array = new Double[numItems];
        for (int i = 0; i < numItems; ++i) {
            array[i] = seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, offset);
            offset += 8L;
        }
        return array;
    }

    @Override
    public int sizeOf(Double item) {
        Objects.requireNonNull(item, "Item must not be null");
        return 8;
    }

    @Override
    public int sizeOf(Double[] items) {
        Objects.requireNonNull(items, "Items must not be null");
        return items.length * 8;
    }

    @Override
    public int sizeOf(MemorySegment seg, long offsetBytes, int numItems) {
        Objects.requireNonNull(seg, "MemorySegment must not be null");
        return numItems * 8;
    }

    @Override
    public String toString(Double item) {
        if (item == null) {
            return "null";
        }
        return item.toString();
    }

    @Override
    public Class<Double> getClassOfT() {
        return Double.class;
    }
}

