/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.MemorySegmentRequest;
import org.apache.datasketches.common.MemorySegmentRequestExample;
import org.apache.datasketches.kll.KllLongsSketch;
import org.apache.datasketches.kll.KllSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllMemorySegmentRequestApp {
    @Test
    public void checkMemorySegmentRequestExample() {
        int k = 200;
        int itemsIn = 2000;
        MemorySegmentRequestExample mSegReqEx = new MemorySegmentRequestExample();
        int numBytes = KllSketch.getMaxSerializedSizeBytes((int)200, (long)200L, (KllSketch.SketchType)KllSketch.SketchType.KLL_LONGS_SKETCH, (boolean)true);
        MemorySegment seg = mSegReqEx.request((long)numBytes);
        KllLongsSketch sk = KllLongsSketch.newDirectInstance((int)200, (MemorySegment)seg, (MemorySegmentRequest)mSegReqEx);
        for (int n = 1; n <= 2000; ++n) {
            sk.update((long)n);
        }
        Assert.assertEquals((long)sk.getMaxItem(), (long)2000L);
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((long)sk.getN(), (long)2000L);
        Assert.assertTrue((sk.getMemorySegment() != seg ? 1 : 0) != 0);
        mSegReqEx.cleanup();
    }
}

