/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.ConnectionField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ConnectionFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.apache.activemq.artemis.utils.StringUtil;

public class ConnectionView
extends ActiveMQAbstractView<RemotingConnection> {
    private static final String defaultSortField = ConnectionField.CONNECTION_ID.getName();
    private final ActiveMQServer server;

    public ConnectionView(ActiveMQServer server) {
        this.server = server;
        this.predicate = new ConnectionFilterPredicate(server);
    }

    @Override
    public Class getClassT() {
        return RemotingConnection.class;
    }

    @Override
    public JsonObjectBuilder toJson(RemotingConnection connection) {
        List<ServerSession> sessions = this.server.getSessions(connection.getID().toString());
        TreeSet<String> users = new TreeSet<String>();
        for (ServerSession session : sessions) {
            String username = session.getUsername() == null ? "" : session.getUsername();
            users.add(username);
        }
        return JsonLoader.createObjectBuilder().add(ConnectionField.CONNECTION_ID.getName(), this.toString(connection.getID())).add(ConnectionField.REMOTE_ADDRESS.getName(), this.toString(connection.getRemoteAddress())).add(ConnectionField.USERS.getName(), StringUtil.joinStringList(users, (String)",")).add(ConnectionField.CREATION_TIME.getName(), new Date(connection.getCreationTime()).toString()).add(ConnectionField.IMPLEMENTATION.getName(), this.toString(connection.getClass().getSimpleName())).add(ConnectionField.PROTOCOL.getName(), this.toString(connection.getProtocolName())).add(ConnectionField.CLIENT_ID.getName(), this.toString(connection.getClientID())).add(ConnectionField.LOCAL_ADDRESS.getName(), this.toString(connection.getTransportLocalAddress())).add(ConnectionField.SESSION_COUNT.getName(), sessions.size());
    }

    @Override
    public Object getField(RemotingConnection connection, String fieldName) {
        ConnectionField field = ConnectionField.valueOfName(fieldName);
        switch (field) {
            case CONNECTION_ID: {
                return connection.getID();
            }
            case REMOTE_ADDRESS: {
                return connection.getRemoteAddress();
            }
            case USERS: {
                TreeSet<String> users = new TreeSet<String>();
                List<ServerSession> sessions = this.server.getSessions(connection.getID().toString());
                for (ServerSession session : sessions) {
                    String username = session.getUsername() == null ? "" : session.getUsername();
                    users.add(username);
                }
                return StringUtil.joinStringList(users, (String)",");
            }
            case CREATION_TIME: {
                return new Date(connection.getCreationTime());
            }
            case IMPLEMENTATION: {
                return connection.getClass().getSimpleName();
            }
            case PROTOCOL: {
                return connection.getProtocolName();
            }
            case CLIENT_ID: {
                return connection.getClientID();
            }
            case LOCAL_ADDRESS: {
                return connection.getTransportLocalAddress();
            }
            case SESSION_COUNT: {
                return this.server.getSessions(connection.getID().toString()).size();
            }
        }
        throw new IllegalArgumentException("Unsupported field, " + fieldName);
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortField;
    }
}

