/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.cayenne.dbsync.merge.MergerDictionary;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfig;
import org.apache.cayenne.dbsync.reverse.filters.TableFilter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;

class DbEntityDictionary
extends MergerDictionary<DbEntity> {
    private final DataMap container;
    private final FiltersConfig filtersConfig;

    DbEntityDictionary(DataMap container, FiltersConfig filtersConfig) {
        this.container = container;
        this.filtersConfig = filtersConfig;
    }

    @Override
    String getName(DbEntity entity) {
        return entity.getName();
    }

    @Override
    Collection<DbEntity> getAll() {
        return this.filter();
    }

    private Collection<DbEntity> filter() {
        if (this.filtersConfig == null) {
            return this.container.getDbEntities();
        }
        LinkedList<DbEntity> existingFiltered = new LinkedList<DbEntity>();
        for (DbEntity entity : this.container.getDbEntities()) {
            TableFilter tableFilter = this.filtersConfig.tableFilter(entity.getCatalog(), entity.getSchema());
            if (tableFilter == null || !tableFilter.isIncludeTable(entity.getName())) continue;
            existingFiltered.add(entity);
        }
        return existingFiltered;
    }
}

